package Pytanie2_1;

import java.util.HashSet;
import java.util.Hashtable;

import CtCILibrary.AssortedMethods;
import CtCILibrary.LinkedListNode;

public class Pytanie {
	public static void deleteDupsA(LinkedListNode n) {
		HashSet<Integer> set = new HashSet<Integer>();
		LinkedListNode previous = null;
		while (n != null) {
			if (set.contains(n.data)) {
				previous.next = n.next;
			} else {
				set.add(n.data);
				previous = n;
			}
			n = n.next;
		}
	}
	
	public static void deleteDupsC(LinkedListNode head) {
		if (head == null) return;
		LinkedListNode previous = head;
		LinkedListNode current = previous.next;
		while (current != null) {
			// Wyszukiwanie powtrze we wczeniejszej czci listy i usuwanie ich
			LinkedListNode runner = head;
			while (runner != current) { 
				if (runner.data == current.data) {
					LinkedListNode tmp = current.next;
					previous.next = tmp;
					current = tmp;
					/* Wiadomo, e przed elementem nie moe by wicej ni 
					 * jeden duplikat,poniewa zostaby wczeniej usunity */
				    break;
				}
				runner = runner.next;
			}
			
			/* Jeli runner == current, nie znaleziono adnych duplikatw
			 * we wczeniejszej ptli for. Naley wic przestawi zmienn current
			 * na nastpny element.  
			 * Jeeli runner != current, musia wystpi warunek prowadzcy do 
			 * instrukcji break. Oznacza to, e znaleziono powtrzenie i zmienna current
			 * zostaa ju przestawiona */
			if (runner == current) {
				previous = current;
		        current = current.next;
			}
		}
	}
	
	public static void deleteDupsB(LinkedListNode head) {
		if (head == null) return;
		
		LinkedListNode current = head;
		while (current != null) {
			/* Usuwa wszystkie dalsze wzy o tej samej wartoci */
			LinkedListNode runner = current;
			while (runner.next != null) { 
				if (runner.next.data == current.data) {
					runner.next = runner.next.next;
				} else {
					runner = runner.next;
				}
			}
			current = current.next;
		}
	}	
	
	public static void main(String[] args) {	
		LinkedListNode first = new LinkedListNode(0, null, null); //AssortedMethods.randomLinkedList(1000, 0, 2);
		LinkedListNode head = first;
		LinkedListNode second = first;
		for (int i = 1; i < 8; i++) {
			second = new LinkedListNode(i % 2, null, null);
			first.setNext(second);
			second.setPrevious(first);
			first = second;
		}
		System.out.println(head.printForward());
		LinkedListNode clone = head.clone();
		deleteDupsA(head);
		System.out.println(head.printForward());
		deleteDupsC(clone);
	}
}
