var http = require('http'),
    five = require('johnny-five'),
    board = new five.Board(),
    fs = require('fs');

function handler(req, res) {
  var path = __dirname;

  if (req.url === "/") {
    path += "/index.html";
  } else {
    path += req.url;
  }

  fs.readFile(path, function(err, data) {
    if (err) {
      res.writeHead(500);
      return res.end("Błąd podczas ładowania " + path);
    }

    res.writeHead(200);
    res.end(data);
  });
}

var app = http.createServer(handler);
var io = require('socket.io')(app);

app.listen(3000);

var tapTimeoutThresh = 30;
var pressureThresh = 800;

var shoes = {
      left: {
        toe: { val: 0, timeout: 0 },
        heel: { val: 0, timeout: 0 }
      },
      right: {
        toe: { val: 0, timeout: 0 },
        heel: { val: 0, timeout: 0 }
      }
    };

board.on('ready', function() {
  console.log('MAOW!');

  var leftToe = new five.Sensor({
    pin: 'A0',
    freq: 25
  });

  var leftHeel = new five.Sensor({
    pin: 'A1',
    freq: 25
  });

  var rightToe = new five.Sensor({
    pin: 'A2',
    freq: 25
  });

  var rightHeel = new five.Sensor({
    pin: 'A3',
    freq: 25
  });

  rightToe.on('data', function() {
    console.log(this.value);
    shoes.right.toe.val = this.value;
  });

  rightHeel.on('data', function() {
    console.log(this.value);
    shoes.right.heel.val = this.value;
  });

  leftToe.on('data', function() {
    console.log(this.value);
    shoes.left.toe.val = this.value;
  });

  leftHeel.on('data', function() {
   console.log(this.value);
    shoes.left.heel.val = this.value;
  });

  // Główna pętla obsługująca tupnięcia
  this.loop(10, function() {

    // Pętla sprawdzająca lewy i prawy but
    for (var foot in shoes) {

      if (!shoes.hasOwnProperty(foot)) continue;
      // Jeżeli użytkownik nie stoi (oba czujniki nacisnięte)
      if (!isStanding(shoes[foot])) {
        // Pętla sprawdzająca piętę i palce
        for (var sensor in shoes[foot]) {

          if (!shoes[foot].hasOwnProperty(sensor)) continue;
          var footSensor = shoes[foot][sensor];
          var timeout = shoes[foot][sensor].timeout;

          if (isPressed(shoes[foot][sensor].val)) {
            shoes[foot][sensor].timeout += 1;
            // Jeżeli czujnik jest naciśnięty odpowiednio długo, oznacza to tupnięcie
            if (timeout > tapTimeoutThresh) {
              console.log('emit', foot + sensor);
              io.emit('tap', foot + sensor);
              shoes[foot][sensor].timeout = 0;
            }

          } else {
            shoes[foot][sensor].timeout = 0;
          }
        }
      // Jeżeli użytkownik stoi, następuje reset czasu czujników
      } else {
        shoes[foot].toe.timeout = 0;
        shoes[foot].heel.timeout = 0;
      }

    } // koniec pętli

 }); // koniec głównej pętli j5

}); // koniec obiektu board

function isPressed(val) {
  if (val > pressureThresh) {
    return true;
  } else {
    return false;
  } 
}

function isStanding(foot) {
  if (isPressed(foot.toe.val) && isPressed(foot.heel.val)) {
    return true;
  } else {
    return false;
  } 
}