var express = require('express');
var path = require('path');
var favicon = require('serve-favicon');
var logger = require('morgan');
var cookieParser = require('cookie-parser');
var bodyParser = require('body-parser');
var routes = require('./routes/index');
var lights = require('./routes/lights');
var five = require('johnny-five');

// Utworzenie obiektu Johnny-Five Led.Matrix do komunikacji z matrycami LED
var board = new five.Board();
board.on("ready",function(){
  var matrices = new five.Led.Matrix({
    devices: 7,
    controller: "HT16K33",
    isBicolor: true
  });
  app.set('matrices', matrices);
});

var app = express();

// Konfiguracja widoku
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'jade');

// Usuń komentarz po umieszczeniu pliku favicon w katalogu /public
//app.use(favicon(__dirname + '/public/favicon.ico'));
app.use(logger('dev'));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));

// Konfiguracja widoku
app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'jade');

// Usuń komentarz po umieszczeniu pliku favicon w katalogu /public
//app.use(favicon(__dirname + '/public/favicon.ico'));
app.use(logger('dev'));
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));

app.use('/', routes);
app.use('/lights', lights);

// Przechwycenie kodu 404 i przekierowanie do obsługi błędów
app.use(function(req, res, next) {
    var err = new Error('Not Found');
    err.status = 404;
    next(err);
});

// Obsługa błędów

// Obsługa błędów dla programistów
// Wyświetlenie stosu wywołań
if (app.get('env') === 'development') {
    app.use(function(err, req, res, next) {
        res.status(err.status || 500);
        res.render('error', {
            message: err.message,
            error: err
        });
    });
}

// Produkcyjna obsługa błędów
// Stos wywołań nie jest wyświetlany
app.use(function(err, req, res, next) {
    res.status(err.status || 500);
    res.render('error', {
        message: err.message,
        error: {}
    });
});

module.exports = app;

  
  