// =======================
// Program oparty na kodzie @makenai robota SumoBot Jr
// =======================

var five = require("johnny-five");
var keypress = require('keypress');

var opts = {};
opts.port = process.argv[2] || "";

keypress(process.stdin);

var board = new five.Board(opts);

board.on("ready", function() {

    console.log("Steruj robotem za pomocą klawiszy strzałek, spacja zatrzymanie, Q wyjście.")

    var left_wheel  = new five.Servo({ pin:  9, type: 'continuous' });
    var right_wheel = new five.Servo({ pin: 8, type: 'continuous'  });

    process.stdin.resume(); 
    process.stdin.setEncoding('utf8'); 
    process.stdin.setRawMode(true); 

    process.stdin.on('keypress', function (ch, key) {

        if ( !key ) return;

        if ( key.name == 'q' ) {
            console.log('Wyjście');
            process.exit();
        } else if ( key.name == 'up' ) {

            console.log('Wprzód');
            left_wheel.cw();
            right_wheel.ccw();

        } else if ( key.name == 'down' ) {

            console.log('Wstecz');
            left_wheel.ccw();
            right_wheel.cw();      

        } else if ( key.name == 'left' ) {

            console.log('W lewo');
            left_wheel.ccw();
            right_wheel.ccw();      

        } else if ( key.name == 'right' ) {

            console.log('W prawo');
            left_wheel.cw();
            right_wheel.cw();

        } else if ( key.name == 'space' ) {

            console.log('Zatrzymanie');
            left_wheel.to(90);
            right_wheel.to(90);
        }
    });
});
