var keypress = require("keypress");

var state = {
  up: false,
  down: false
};

board.on("ready", function() {
  keypress(process.stdin);

  var motor = new five.Motor({
    pins: {
      pwm: "A0",
      dir: "D1",
      cdir: "D0"
    }
  });

  process.stdin.on("keypress", function (ch, key) {
    if (key.name === "up" && !state.up) {
      state.down = false;
      state.up = true;
      return motor.forward(255);
    }
    if (key.name === "down" && !state.down) {
      state.up = false;
      state.down = true;
      return motor.reverse(255);
    }
    if (key.name === "space" && (state.up || state.down)) {
      state.down = false;
      state.up = false;
      return motor.stop();
    }
  });
});
