var request = require("request"),
  five = require("johnny-five"),
  twit = require("node-tweet-stream"),
  colorMap = require("./cheerlights-colors"),
  board = new five.Board();

board.on("ready", function() {

  var lastColor = "white",
  led = new five.Led.RGB([3,5,6]);

  led.color( colorMap[lastColor] );

  t = new twit({
    consumer_key: process.env.TWITTER_API_KEY,
    consumer_secret: process.env.TWITTER_API_SECRET,
    token: process.env.TWITTER_TOKEN,
    token_secret: process.env.TWITTER_TOKEN_SECRET
  });

  t.track("@cheerlights");
  t.track("#cheerlights");

  t.on("tweet", function (tweet) {
    // Odczyt nazwy koloru z tweeta
    Object.keys(colorMap).some(function(color) {
      if ( tweet.text.indexOf(color) >= 0 ) {
        if ( color != lastColor ) {
          lastColor = color;
          console.log( "Zmiana koloru na " + color );
          led.color( colorMap[color] );
        }
        return true;
      } else {
        return false;
      }
    });
  });

  t.on("error", function (err) {
    console.log("Błąd obsługi kanału Twitter: %o", err);
  });

});