package org.coffeeshop;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.Payload;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Oglna adnotacja suca do weryfikacji
 * obiektw wyliczeniowych
 * @author Bhakti Mehta
 */
@Retention(RUNTIME)
@Target({FIELD, METHOD})
@Documented
@Constraint(validatedBy = VerifyValueValidator.class)
public @interface VerifyValue {

        String message() default "Podana warto jest niepoprawna.";
        Class<?>[] groups() default {};
        Class<? extends Payload>[] payload() default {};
        Class<? extends Enum<?>> value();

}


