import summarizer from './summarizer'

describe('funckcja summarizer', () => {
  it('powinna zwracać 0 jeśli koszyk jest pusty', () => {
    const actual = summarizer({ basket: [] })
    expect(actual).toEqual({ itemCount: 0, cost: 0.0 })
  })
  it('powinna mnożyć cenę produktu przez ilość egzemplarzy', () => {
    const actual = summarizer({
      basket: [{ productId: '1234', quantity: 2, price: 1.23 }],
    })
    expect(actual).toEqual({ itemCount: 2, cost: 2.46 })
  })
  it('powinna obsługiwać wiele produktów', () => {
    const actual = summarizer({
      basket: [
        { productId: '1234', quantity: 2, price: 1.23 },
        { productId: '5678', quantity: 1, price: 1.5 },
      ],
    })
    expect(actual).toEqual({ itemCount: 3, cost: 3.96 })
  })
})
