function getDescription(element) {
  const nodeName = element.nodeName.toUpperCase();
  const role = element.role ? element.role : (nodeName === 'BUTTON')
    ? 'przycisk'
    : (nodeName === 'INPUT' || nodeName === 'TEXTAREA')
      ? 'pole tekstowe ' + element.value
      : (nodeName === 'SELECT')
        ? 'lista ' + element.value
        : (element.getAttribute('role') || 'group');
  const title = element.title || element.textContent;
  const extraInstructions = (nodeName === 'INPUT' || nodeName === 'TEXTAREA')
    ? 'Znajdujesz się w polu tekstowym. Zacznij wpisywać.'
    : '';
  return role + '. ' + title + '. ' + extraInstructions;
}

function talkToMe() {
  if ((process.env.NODE_ENV !== 'production') && (sessionStorage.getItem('talkToMe') === "true")) {
    document.addEventListener('focusin', evt => {
      if (sessionStorage.getItem('talkToMe') === "true") {
        const description = getDescription(evt.target);
        if (window.speechSynthesis.speaking) {
          window.speechSynthesis.cancel();
        }
        window.speechSynthesis.speak(new SpeechSynthesisUtterance(description));
      }
    });
  }
}

export default talkToMe;
