import { useState } from 'react'
import Logout from './Logout'
import axios from 'axios'
import { create } from '@github/webauthn-json'

const Private2 = () => {
  const [busy, setBusy] = useState(false)
  const [message, setMessage] = useState()

  const registerToken = async (startRegistrationEndpoint) => {
    setBusy(true)
    try {
      const response = await axios.post(startRegistrationEndpoint)
      setMessage('Wysyłanie żądania')
      const attestation = await create({ publicKey: response.data })
      setMessage('Utworzenie atestacji')
      const attestationResponse = await axios.post('/register', {
        attestation,
      })
      setMessage('Zarejestrowano!')
      if (
        attestationResponse.data &&
        attestationResponse.data.verified
      ) {
        alert('Zarejestrowano nowy klucz')
      }
    } catch (err) {
      setMessage('' + err)
    } finally {
      setBusy(false)
    }
  }
  return (
    <div className="Private2">
      <h1>Strona konta</h1>

      {window.PublicKeyCredential && (
        <>
          <p>Rejestracja nowego klucza sprzętowego</p>
          <button
            onClick={() => registerToken('/startRegister')}
            disabled={busy}
          >
            Zarejestruj usuwalny token
          </button>
          <button
            onClick={() => registerToken('/startFingerprint')}
            disabled={busy}
          >
            Zarejestruj czytnik linii papilarnych
          </button>
        </>
      )}
      <div className="Account-message">{message}</div>

      <Logout />
    </div>
  )
}

export default Private2
