import { useState } from 'react'
import './App.css'
import Ticker from './Ticker'
import SimpleTicker from './SimpleTicker'
import IntervalTicker from './IntervalTicker'
import { BrowserRouter, Link, Route, Switch } from 'react-router-dom'

function App() {
  const [hidden, setHidden] = useState(false)

  return (
    <div className="App">
      <BrowserRouter>
        <Switch>
          <Route path="/simple">
            <SimpleTicker />
          </Route>
          <Route path="/interval">
            <IntervalTicker />
          </Route>
          <Route path="/clocks">
            <h1>Zegary</h1>
            <button onClick={() => setHidden((h) => !h)}>
              {hidden ? 'Pokaż' : 'Ukryj'}
            </button>
            {hidden || <Ticker />}
          </Route>
          <ul>
            <li>
              <Link to="/simple">Prosty zegar</Link>
            </li>
            <li>
              <Link to="/interval">Odliczanie dłuższych okresów</Link>
            </li>
            <li>
              <Link to="/clocks">Kolekcja zegarów</Link>
            </li>
          </ul>
        </Switch>
      </BrowserRouter>
    </div>
  )
}

export default App
