import Dialog from "@material-ui/core/Dialog";
import DialogTitle from "@material-ui/core/DialogTitle";
import Typography from "@material-ui/core/Typography";
import DialogContent from "@material-ui/core/DialogContent";
import DialogActions from "@material-ui/core/DialogActions";
import Button from "@material-ui/core/Button";
import CloseIcon from '@material-ui/icons/Close';

export const MyDialog = ({onClose, open, title, children}) => {
    return <Dialog
        open={open}
        onClose={onClose}
    >
        <DialogTitle>
            <Typography component='h1' variant='h5' color='inherit' noWrap>
                {title}
            </Typography>
        </DialogTitle>
        <DialogContent>
            {children}
        </DialogContent>
        <DialogActions>
            <Button variant='outlined'
                    startIcon={<CloseIcon />}
                    onClick={onClose}>
                Close
            </Button>
        </DialogActions>
    </Dialog>;
};
