import {render, screen} from '@testing-library/react';
import user from '@testing-library/user-event';
import Skip from "./Skip";

describe('Komponent Skip', () => {
    let after, afterSkip, before, beforeSkip, first, last;
    beforeEach(() => {
        render(<>
            <label htmlFor='before'>pole pierwsze</label>
            <input id='before'/>
            <Skip name='things'>
                <label htmlFor='first'>pole drugie</label>
                <input id='first'/>
                <label htmlFor='last'>pole trzecie</label>
                <input id='last'/>
            </Skip>
            <label htmlFor='after'>pole czwarte</label>
            <input id='after'/>
        </>);
        afterSkip = screen.getByText(/wróć przed things/i);
        before = screen.getByLabelText(/pole pierwsze/i);
        beforeSkip = screen.getByText(/pomiń things/i);
        after = screen.getByLabelText(/pole czwarte/i);
        first = screen.getByLabelText(/pole drugie/i);
        last = screen.getByLabelText(/pole trzecie/i);
    })
    it('powinien wyświetlić przycisk pominięcia po wejściu do obszaru', async () => {
        user.click(before);
        user.tab();
        expect(beforeSkip).toHaveFocus();
        user.type(beforeSkip, "{enter}")
        expect(after).toHaveFocus();
    })
    it('powinien wyświetlić przycisk powrot przed obszar', async () => {
        user.click(after);
        user.tab({shift: true})
        expect(afterSkip).toHaveFocus();
        user.type(afterSkip, "{enter}")
        expect(before).toHaveFocus();
    })
    it('powinien pozwalać na zrezygnowanie z pominięcia', async () => {
        user.click(before);
        user.tab();
        expect(beforeSkip).toHaveFocus();
        user.tab();
        expect(first).toHaveFocus();
        user.tab({shift: true})
        expect(before).toHaveFocus();
    })
    it('powinien pozwalać na zrezygnowanie z cofnięcia się', async () => {
        user.click(after);
        user.tab({shift: true})
        expect(afterSkip).toHaveFocus();
        user.tab({shift: true})
        expect(last).toHaveFocus();
        user.tab()
        expect(after).toHaveFocus();
    })
});