import { useEffect, useState } from 'react'
import { Prompt } from 'react-router-dom'

const Important = () => {
  let initialValue = 'Wartość początkowa'

  const [data, setData] = useState(initialValue)
  const [dirty, setDirty] = useState(false)

  useEffect(() => {
    if (data !== initialValue) {
      setDirty(true)
    }
  }, [data, initialValue])

  return (
    <div className="Important">
      <textarea
        onChange={(evt) => setData(evt.target.value)}
        cols={40}
        rows={12}
      >
        {data}
      </textarea>
      <br />
      <button onClick={() => setDirty(false)} disabled={!dirty}>
        Zapisz
      </button>
      <Prompt
        when={dirty}
        message={() => 'Czy naprawdę chcesz opuścić stronę?'}
      />
    </div>
  )
}

export default Important
