import {render, screen} from '@testing-library/react';
import usePersistentState from "./usePersistentState";

describe('usePersistentState', () => {
    beforeEach(() => {
        localStorage.clear();
    })

    it('powinine być w porządku jeśli nie ma istniejącego stanu', () => {

        const Example = () => {
            usePersistentState('something', []);

            return <div>Witamy</div>
        }

        render(<Example/>);
    });
    it('powinien używać istniejącego stanu, jeśli taki jest dostępny', () => {

        const Example = () => {
            const [v] = usePersistentState('something', '');

            return <div>{v}</div>
        }

        localStorage.setItem('something', JSON.stringify('Istniejąca wartość'));
        render(<Example/>);
        screen.getByText('Istniejąca wartość')
    });
    it('powinien aktualizować przechowywaną wartość po wywołaniu funkcji ustawiającej', () => {

        const Example = () => {
            const [v, setV] = usePersistentState('something', 0);

            return <div>
                <div>Licznik: {v}</div>
                <button onClick={() => setV(c => c + 1)}>kliknij</button>
            </div>
        }

        render(<Example/>);
        screen.getByText('Licznik: 0')
        screen.getByText(/kliknij/i).click()
        screen.getByText(/kliknij/i).click()
        screen.getByText(/kliknij/i).click()
        screen.getByText(/kliknij/i).click()
        screen.getByText(/kliknij/i).click()
        screen.getByText(/kliknij/i).click()
        screen.getByText('Licznik: 6')
        expect(localStorage.getItem('something')).toEqual('6');
    });
    it('powinien zaktualizować przechowywaną wartość, gdy zostanie wywołana procedura obsługi', () => {

        const Example = () => {
            const [v, setV] = usePersistentState('clicked', false);

            return <div>
                <div>Kliknięty: {JSON.stringify(v)}</div>
                <button onClick={() => setV(true)}>Kliknij mnie</button>
            </div>
        }

        render(<Example/>);
        screen.getByText('Kliknięty: false')
        screen.getByText(/kliknij mnie/i).click()
        screen.getByText('Kliknięty: true')
        expect(localStorage.getItem('clicked')).toEqual('true');
    });
});