describe('można edytować zadanie', () => {
    it('powinna istnieć możliwość edycji zadania', () => {
        cy.visit('/');
        cy.contains('+').click();
        cy.getByLabel(/tytuł/i).type('Kupić chleb')
        cy.getByLabel(/opis/i).type('Może uda się dostać ciabattę')
        cy.getByLabel(/kontekst/i).select('shopping')
        cy.contains(/zapisz/i).click()
        cy.get('.TaskList').eq(0).click();
        cy.get('input[name=title]').should('have.value', 'Kupić chleb')
        cy.get('textarea[name=description]').should('have.value', 'Może uda się dostać ciabattę')
        cy.get('select[name=context]').should('have.value', 'shopping')
        cy.get('input[name=title]').clear().type('Warsztaty')
        cy.get('textarea[name=description]').clear().type('Zapytać o tematykę i zadania')
        cy.get('select[name=context]').select('phone')
        cy.contains(/zapisz/i).click()
        cy.get('h2').eq(0).should('have.text', 'Telefon')
        cy.get('.TaskList').eq(0).find('.Task .Task-title').contains('Warsztaty').should('be.visible')
        cy.get('.TaskList').eq(0).find('.Task .Task-description').contains('Zapytać o tematykę i zadania').should('be.visible')
        cy.get('h2').should('have.length', 1)
        cy.contains('+').click();
        cy.getByLabel(/tytuł/i).type('Zadzwonić do znajomych')
        cy.getByLabel(/opis/i).type('Zapytać czy możemy się umówić na czwartek')
        cy.getByLabel(/kontekst/i).select('phone')
        cy.contains(/zapisz/i).click()
        cy.get('h2').eq(0).should('have.text', 'Telefon')
        cy.get('h2').should('have.length', 1)
        cy.get('.TaskList').find('.Task .Task-title').eq(0).contains('Warsztaty').should('be.visible')
        cy.get('.TaskList').find('.Task .Task-description').eq(0).contains('Zapytać o tematykę i zadania').should('be.visible')
        cy.get('.TaskList').find('.Task .Task-title').eq(1).contains('Zadzwonić do znajomych').should('be.visible')
        cy.get('.TaskList').find('.Task .Task-description').eq(1).contains('Zapytać czy możemy się umówić na czwartek').should('be.visible')
    });
});