import { MemoryRouter } from 'react-router'
import { Route } from 'react-router-dom'
import { fireEvent, render, screen } from '@testing-library/react'
import React from 'react'

import About from './About'

describe('Komponent About', () => {
  it.skip('nie powiedzie się, bo nie ma trasy', () => {
    render(<About />)
    expect(screen.getByText('Krystyna Słomka')).toBeInTheDocument()
  })
  it('powinien wyświetlić listę osób', () => {
    render(
      <MemoryRouter>
        <About />
      </MemoryRouter>
    )

    expect(screen.getByText('Krystyna Słomka')).toBeInTheDocument()
  })
  it('powinien wyświetlić biura, jeśli wybrano odpowiednią trasę', () => {
    render(
      <MemoryRouter initialEntries={[{ pathname: '/about/offices' }]}>
        <About />
      </MemoryRouter>
    )

    expect(screen.getByText('Warszawa')).toBeInTheDocument()
  })
  it('powinna istnieć możliwość kliknięcia, by wyświetlić biura', () => {
    render(
      <MemoryRouter initialEntries={[{ pathname: '/about' }]}>
        <About />
      </MemoryRouter>
    )

    expect(screen.getByText('Krystyna Słomka')).toBeInTheDocument()

    fireEvent(
      screen.getByText('Biura'),
      new MouseEvent('click', {
        bubbles: true,
        cancelable: true,
      })
    )

    expect(screen.getByText('Warszawa')).toBeInTheDocument()
  })
})
