import {useState} from "react";
import useTaskContexts from "./useTaskContexts";
import useTasks from "./useTasks";
import ModalQuestion from "./ModalQuestion";
import TaskContexts from "./TaskContexts";
import TaskForm from "./TaskForm";
import './App.css';
import SkipButton from "./SkipButton";

const App = () => {
  const contexts = useTaskContexts();
  const {tasks, save, remove} = useTasks();
  const [editTask, setEditTask] = useState();
  const [taskToRemove, setTaskToRemove] = useState();
  const [formOpen, setFormOpen] = useState(false);

  return (
    <>
      <header>
        <SkipButton onClick={() => document.querySelector('.addButton').focus()}>
          Przeskocz do treści
        </SkipButton>
        <h1>Menedżer zadań</h1>
      </header>
      <nav>
        <a href='/contacts'>Kontakty</a>&nbsp;|&nbsp;
        <a href='/events'>Zdarzenia</a>&nbsp;|&nbsp;
        Zadania&nbsp;|&nbsp;
        <a href='/notes'>Notes</a>&nbsp;|&nbsp;
        <a href='/time'>Rejestracja czasu</a>&nbsp;|&nbsp;
        <a href='/diary'>Dziennik</a>&nbsp;|&nbsp;
        <a href='/expenses'>Wydatki</a>&nbsp;|&nbsp;
        <a href='/invoices'>Faktury</a>
      </nav>
      <main>
        <button aria-haspopup='dialog' className='addButton' onClick={() => setFormOpen(true)}>+</button>
        <TaskContexts contexts={contexts}
                tasks={tasks}
                onDelete={setTaskToRemove}
                onEdit={task => {
                  console.log('obsługa onEdit')
                  
                  setEditTask(task);
                  setFormOpen(true);
                }}
        />
      </main>
      <footer>
        &#169;2029, Ogarniacze Rzeczywistości. Spółka Konsultingowa. Wszelkie prawa zastrzeżone.
      </footer>
      <TaskForm contexts={contexts}
            onCreate={task => {
              save(task);
              setEditTask(null);
            }}
            task={editTask}
            open={formOpen}
            onClose={() => setFormOpen(false)}
      />
      <ModalQuestion
        open={taskToRemove}
        onYes={() => {
          remove(taskToRemove);
          setTaskToRemove(null);
        }}
        onNo={() => {
          setTaskToRemove(null);
        }}
      >
        Czy jesteś pewny, że chcesz usunąć to zadanie?
      </ModalQuestion>
    </>
  );
};

export default App;
