function terminalLog(violations) {
  cy.task(
    'log',
    `Wykryto problemy z dostępnością! Liczba wykrytych 
       problemów: ${violations.length}.`
  )

  const violationData = violations.map(
    ({ id, impact, description, nodes }) => ({
      id,
      impact,
      description,
      nodes: nodes.length
    })
  )

  cy.task('table', violationData)
  console.table(violationData)
}

describe('może być użyty', () => {
  it('powinien być dostępny podczas uruchamiania aplikacji', () => {
    cy.visit('/');
    cy.injectAxe();
    cy.checkA11y(null, null, terminalLog);
  });

  it('ma być dostępny podczas tworzenia zadania', () => {
    cy.visit('/');
    cy.injectAxe();
    cy.configureAxe({
      rules: [{ id: 'tabindex', enabled: false }]
    })
    cy.contains('+').click();
    cy.checkA11y(null, null, terminalLog);
  });
});