import {Builder, By, until} from "selenium-webdriver";

require('chromedriver');

let driver;

describe('Podstawowe możliwości gry', () => {
  beforeEach(() => {
    driver = new Builder().forBrowser('chrome').build();
  });

  afterEach(() => {
    driver.quit();
  });

  it('gra powinna mnie poinformować kiedy wygram', async () => {
    // Przy założeniu, że uruchomiłem aplikację
    await driver.get('http://localhost:3000');
    // kiedy wpiszę prawidłową odpowiedź
    
    const [number1, number2, input, submit] = await Promise.all([
      driver.findElement(By.css('.number1')).getText(),
      driver.findElement(By.css('.number2')).getText(),
      driver.findElement(By.css('input')),
      driver.findElement(By.xpath("//button[text()='Prześlij']"))
    ]);
    
    await input.sendKeys('' + (number1 * number2));
    await submit.click();
    // zostanę poinformowany o zwycięstwie
    // const resultText = await driver.findElement(By.css('.Result')).getText();
    // expect(resultText).toMatch(/wygrałeś/i);
    await driver.wait(until.elementLocated(By.css('.Result')));
    const resultElement = driver.findElement(By.css('.Result'));
    await driver.wait(until.elementTextMatches(resultElement, /wygrałeś/i));
  }, 60000);
});
