import { useState } from 'react'
import Logout from './Logout'
import useSecurity from './useSecurity'

export default () => {
  const security = useSecurity()
  const [message, setMessage] = useState()

  const doDangerousThing = async () => {
    try {
      await security.confirmLogin()
      setMessage('NIEBEZPIECZNA OPERACJA!')
    } catch (err) {
      setMessage('ANULOWANO WYKONANIE NIEBEZPIECZNEJ OPERACJI!')
    }
  }

  return (
    <div className="Private1">
      <h1>Pierwsza strona prywatna</h1>

      <button
        onClick={() => {
          doDangerousThing()
        }}
      >
        Wykonaj niebezpieczną operację
      </button>

      <p className="message">{message}</p>

      <Logout />
    </div>
  )
}
