import Calendar from "./Calendar";
import YearCalendar from "./YearCalendar"
import {useState} from "react";

export default {
    title: 'Komponent Calendar',
    component: Calendar,
};

export const Podstawowy = () => <Calendar year={2021} month={4}/>

export const Nawigacja = () => {
    const [month, setMonth] = useState(4);
    return <div>
        <button
            onClick={() => setMonth(m => m - 1)}
        >Poprzedni</button>
        <button
            onClick={() => setMonth(m => m + 1)}
        >Następny</button>
        <Calendar year={2021} month={month}/>
    </div>
}

export const WieleKalendarzy = () => {
    const cals = [];
    for (let i = 1; i <= 12; i++) {
        cals.push(<Calendar year={2021} month={i}/>)
    }
    return cals;
}

export const KalendarzRoczny = () => <YearCalendar/>;