describe('można tworzyć zadania', () => {
    it('powinna istnieć możliwość utworzenia nowego zadania', () => {
        cy.visit('/');
        cy.get('h2').should('not.exist')
        cy.contains(/zapisz/i).should('not.exist')
        cy.contains('+').click();
        cy.contains(/zapisz/i).should('be.visible')
        cy.getByLabel(/tytuł/i).type('Kupić chleb')
        cy.getByLabel(/opis/i).type('Może uda się dostać ciabattę')
        cy.getByLabel(/kontekst/i).select('shopping')
        cy.contains(/anuluj/i).click()
        cy.contains(/zapisz/i).should('not.exist')
        cy.contains('+').click();
        cy.getByLabel(/tytuł/i).should('have.value', '')
        cy.getByLabel(/opis/i).should('have.value', '')
        cy.getByLabel(/kontekst/i).should('have.value', '')
        cy.getByLabel(/tytuł/i).type('Kupić chleb')
        cy.getByLabel(/opis/i).type('Może uda się dostać ciabattę')
        cy.getByLabel(/kontekst/i).select('shopping')
        cy.contains(/zapisz/i).click()
        cy.contains(/zapisz/i).should('not.exist')
        cy.get('h2').should('have.text', 'Zakupy')
        cy.get('.TaskList .Task .Task-title').contains('Kupić chleb').should('be.visible')
        cy.get('.TaskList .Task .Task-description').contains('Może uda się dostać ciabattę').should('be.visible')
        cy.contains('+').click();
        cy.getByLabel(/tytuł/i).should('have.value', '')
        cy.getByLabel(/opis/i).should('have.value', '')
        cy.getByLabel(/kontekst/i).should('have.value', '')
    });
    it('powinna istnieć możliwość utworzenia zadania w innym kontekście', () => {
        cy.visit('/');
        cy.contains('+').click();
        cy.getByLabel(/tytuł/i).type('Kupić chleb')
        cy.getByLabel(/opis/i).type('Może uda się dostać ciabattę')
        cy.getByLabel(/kontekst/i).select('shopping')
        cy.contains(/zapisz/i).click()
        cy.contains('+').click();
        cy.getByLabel(/tytuł/i).type('Warsztaty')
        cy.getByLabel(/opis/i).type('Zapytać o tematykę i zadania')
        cy.getByLabel(/kontekst/i).select('phone')
        cy.contains(/zapisz/i).click()
        cy.get('h2').eq(0).should('have.text', 'Telefon')
        cy.get('.TaskList').eq(0).find('.Task .Task-title').contains('Warsztaty').should('be.visible')
        cy.get('.TaskList').eq(0).find('.Task .Task-description').contains('Zapytać o tematykę i zadania').should('be.visible')
        cy.get('h2').eq(1).should('have.text', 'Zakupy')
        cy.get('.TaskList').eq(1).find('.Task .Task-title').contains('Kupić chleb').should('be.visible')
        cy.get('.TaskList').eq(1).find('.Task .Task-description').contains('Może uda się dostać ciabattę').should('be.visible')
    });
    it('zadana powinny istnieć nawet po odświeżeniu strony', () => {
        cy.visit('/');
        cy.contains('+').click();
        cy.getByLabel(/tytuł/i).type('Kupić chleb')
        cy.getByLabel(/opis/i).type('Może uda się dostać ciabattę')
        cy.getByLabel(/kontekst/i).select('shopping')
        cy.contains(/zapisz/i).click()
        cy.reload();
        cy.get('h2').should('have.text', 'Zakupy')
        cy.get('.TaskList .Task .Task-title').contains('Kupić chleb').should('be.visible')
    })
});