import { useState } from 'react'
import useSecurity from './useSecurity'

const Login = () => {
  const { login } = useSecurity()
  const [username, setUsername] = useState()
  const [password, setPassword] = useState()

  return (
    <div>
      <h1>Formularz logowania</h1>

      <p>Musisz się zalogować. (podpowiedź: wpisz franek/tajnehaslo)</p>

      <label htmlFor="username">Użytkownik:</label>
      <input
        id="username"
        name="username"
        type="text"
        value={username}
        onChange={(evt) => setUsername(evt.target.value)}
      />

      <br />
      <label htmlFor="password">Hasło:</label>
      <input
        id="password"
        name="password"
        type="password"
        value={password}
        onChange={(evt) => setPassword(evt.target.value)}
      />

      <br />
      <button onClick={() => login(username, password)}>Zaloguj się</button>
    </div>
  )
}

export default Login
