import deletionReducer from './deletionReducer'

describe('Reduktor deletionReducer', () => {
  it('powinien wyświetlić okienko logowania, jeśli jeszcze nie jesteśmy zalogowani', () => {
    const actual = deletionReducer({}, { type: 'START_DELETION' })
    expect(actual.showLogin).toBe(true)
    expect(actual.message).toBe('')
    expect(actual.deleteButtonDisabled).toBe(true)
    expect(actual.loginError).toBe('')
    expect(actual.showConfirmation).toBe(false)
  })
  it('nie powinien wyświetlać okienka logowania jeśli już jesteśmy zalogowani', () => {
    const actual = deletionReducer(
      { loggedIn: true },
      { type: 'START_DELETION' }
    )
    expect(actual.showLogin).toBe(false)
    expect(actual.showConfirmation).toBe(true)
  })
  it('powinien zapewniać możliwość anulowania logowania, po czym żadne okna dialogowe nie będą widoczne', () => {
    const actual = deletionReducer(
      { showLogin: true },
      { type: 'CANCEL_DELETION' }
    )
    expect(actual.showLogin).toBe(false)
    expect(actual.showConfirmation).toBe(false)
    expect(actual.showResult).toBe(false)
    expect(actual.message).toBe('Usuwanie anulowano')
    expect(actual.deleteButtonDisabled).toBe(false)
  })
  it('nie powinien przepuszczać dalej jeśli podano złe hasło', () => {
    const actual = deletionReducer(
      { showLogin: true },
      { type: 'LOGIN', payload: 'wrongpassword' }
    )
    expect(actual.showLogin).toBe(true)
    expect(actual.showConfirmation).toBe(false)
    expect(actual.loginError).toBe('Nieprawidłowe hasło')
  })
  it('powinien przepuści użytkownika dalej po podaniu prawidłowego hasła', () => {
    const actual = deletionReducer(
      { showLogin: true },
      { type: 'LOGIN', payload: 'swordfish' }
    )
    expect(actual.showLogin).toBe(false)
    expect(actual.showConfirmation).toBe(true)
    expect(actual.loginError).toBe('')
    expect(actual.loggedIn).toBe(true)
  })
  it('powiniene wyświetlić wynik usuwania po potwierdzeniu operacji', () => {
    const actual = deletionReducer(
      { showConfirmation: true },
      { type: 'CONFIRM_DELETION' }
    )
    expect(actual.showConfirmation).toBe(false)
    expect(actual.showResult).toBe(true)
    expect(actual.message).toBe('Widżet został usunięty')
  })
  it('po zakończeniu powinien wyświetlić komunikat i włączyć przycisk', () => {
    const actual = deletionReducer(
      { showConfirmation: true, message: 'Witaj!' },
      { type: 'FINISH' }
    )
    expect(actual.showLogin).toBe(false)
    expect(actual.showConfirmation).toBe(false)
    expect(actual.showResult).toBe(false)
    expect(actual.message).toBe('Witaj!')
    expect(actual.deleteButtonDisabled).toBe(false)
  })
  it('powinien zgłosić błąd po przekazaniu nieznanej akcji', () => {
    const t = () => deletionReducer({}, { type: 'COŚ_ZŁEGO' })
    expect(t).toThrow(new Error('Nieznana akcja: COŚ_ZŁEGO'))
  })
})
