import {useDispatch, useSelector} from "react-redux";

import "./Basket.css";

export default () => {
    const basket = useSelector(state => state.basket);
    const dispatch = useDispatch();

    return <div className='Basket'>
        <h2>Koszyk</h2>
        {
            (basket && basket.length) ?
                <>
                    {basket.map(item => <div className='Basket-item'>
                        <div className='Basket-itemName'>
                            {item.name}
                        </div>
                        <div className='Basket-itemProductId'>
                            {item.productId}
                        </div>
                        <div className='Basket-itemPricing'>
                            <div className='Basket-itemQuantity'>
                                {item.quantity}
                            </div>
                            <div className='Basket-itemPrice'>
                                {item.price.toLocaleString("pl-PL")} zł
                            </div>
                        </div>
                    </div>)}
                    <button
                        onClick={() => dispatch({type: 'clearBasket'})}>
                        Wyczyść
                    </button>
                </>
                : "Koszyk jest pusty"
        }
    </div>;
};
