import React, { Component } from "react";

import { ImageBackground, CameraRoll } from "react-native";

import styles from "./style";

class FotoTlo extends Component {
  constructor(props) {
    super(props);
    this.state = { zrodloZdjecia: null };
  }

  componentDidMount() {
    CameraRoll.getPhotos({ first: 1 }).then(data => {
      this.setState({ zrodloZdjecia: { uri: data.edges[3].node.image.uri } });
    }, error => {
      console.warn(error);
    });
  }

  render() {
    return (
      <ImageBackground
        style={styles.tlo}
        source={this.state.zrodloZdjecia}
        resizeMode="cover"
      >
        {this.props.children}
      </ImageBackground>
    );
  }
}

export default FotoTlo;
