import React, {Component} from "react";
import {StyleSheet, View} from "react-native";
import {StackNavigator} from "react-navigation";
import {createStore} from "redux";
import {Provider} from "react-redux";
import {reduktor} from "../reduktory";

import Logo from "./Naglowek/Logo";
import EkranTalii from "./EkranTalii";
import EkranNowejKarty from "./EkranNowejKarty";
import EkranPowtorki from "./EkranPowtorki";
import {zaladujTalie} from "../magazyn/talie"
import {zaladujDane} from "../akcje/kreatory";

let magazyn = createStore(reduktor);
let opcjeNaglowka = {
    headerStyle: {backgroundColor: "#FFFFFF"},
    headerLeft: <Logo/>
};
zaladujTalie().then(talie => {
    magazyn.dispatch(zaladujDane(talie));
});

const Nawigator = StackNavigator({
    EkranGlowny: {screen: EkranTalii, navigationOptions: opcjeNaglowka},
    Powtorka: {screen: EkranPowtorki, navigationOptions: opcjeNaglowka},
    StworzNowaKarte: {screen: EkranNowejKarty, path: "StworzNowaKarte/:idTalii", navigationOptions: opcjeNaglowka}
});

class App extends Component {
    render() {
        return (
            <Provider store={magazyn}>
                <Nawigator/>
            </Provider>
        );
    }
}

export default App;
