import React, { Component } from "react";
import { StyleSheet, View, TouchableOpacity } from "react-native";

import colors from "../style/kolory";

class Button extends Component {
  static displayName = "Button";

  render() {
    let przezroczystosc = this.props.zablokowany ? 1 : 0.5;
    return (
      <TouchableOpacity
        activeOpacity={przezroczystosc}
        onPress={this.props.naNacisniecie}
        style={[styles.szerokiPrzycisk, this.props.style]}
      >
        {this.props.children}
      </TouchableOpacity>
    );
  }
}

Button.defaultProps = { disabled: false };

export default Button;

const styles = StyleSheet.create({
  szerokiPrzycisk: {
    justifyContent: "center",
    alignItems: "center",
    padding: 10,
    margin: 10,
    backgroundColor: colors.pink
  }
});
