import React, { Component } from "react";
import { StyleSheet, View } from "react-native";

import TekstNaglowka from "./../TekstNaglowka";
import NormalnyTekst from "./../NormalnyTekst";
import Button from "./../Button";
import colors from "../../style/kolory";

function utworzPodsumowanie(procentowaIloscPoprawnych, funkcjaWyjscia) {
  return (
    <View style={styles.koniec}>
      <TekstNaglowka style={styles.alternatywnie}>
        Odpowiedzi poprawne!
      </TekstNaglowka>
      <NormalnyTekst style={styles.alternatywnie}>
        {Math.round(procentowaIloscPoprawnych * 100)}% poprawnych
      </NormalnyTekst>
      <Button naNacisniecie={funkcjaWyjscia} style={styles.przyciskZakonczenia}>
        <NormalnyTekst>Zakończ</NormalnyTekst>
      </Button>
    </View>
  );
}

const styles = StyleSheet.create({
  alternatywnie: { color: "#FFFFFF" },
  koniec: { alignItems: "center" },
  przyciskZakonczenia: { backgroundColor: colors.tan }
});

export { utworzPodsumowanie };
