import React, { Component } from "react";

import Button from "./../Button";
import styles from "./style.js";

const style = { backgroundColor: "#DDDDDD" };

class PrzyciskLokalizacji extends Component {
  _nacisniecie() {
    navigator.geolocation.getCurrentPosition(
      initialPosition => {
        this.props.onGetCoords(
          initialPosition.coords.latitude,
          initialPosition.coords.longitude
        );
      },
      error => {
        alert(error.message);
      },
      { enableHighAccuracy: true, timeout: 20000, maximumAge: 1000 }
    );
  }

  render() {
    return (
      <Button
        label="Pobierz bieżącą lokalizację"
        style={style}
        onPress={this._nacisniecie.bind(this)}
      />
    );
  }
}

export default PrzyciskLokalizacji;
