import React, { Component } from "react";
import { StyleSheet, View } from "react-native";

import Button from "./../Button";
import NormalnyTekst from "./../NormalnyTekst";
import Wejscie from "../Wejscie";

import colors from "../../style/kolory";

class PrzyciskTworzeniaTalii extends Component {
  render() {
    return (
      <Button style={styles.stworzTalie} naNacisniecie={this.props.naNacisniecie}>
        <NormalnyTekst>Stworz talię</NormalnyTekst>
      </Button>
    );
  }
}

class WejdzDoTalii extends Component {
  constructor(props) {
    super(props);
    this.state = { tekst: "" };
  }

  stworz = () => {
    this.props.stworz(this.state.tekst);
  };

  render() {
    return (
      <View>
        <Wejscie
          naWpis={this.props.stworz}
          naZmiane={tekstDoZmiany => {
            this.setState({ tekst: tekstDoZmiany });
          }}
        />
        <PrzyciskTworzeniaTalii naNacisniecie={this.stworz} />
      </View>
    );
  }
}

const styles = StyleSheet.create({
  stworzTalie: { backgroundColor: colors.green }
});

export { PrzyciskTworzeniaTalii, WejdzDoTalii };
