import React, {Component} from "react";
import {View} from "react-native";

import {MakietyTalii} from "../../dane/Makiety";
import Talia from "./Talia";
import TworzenieTalii from "./TworzenieTalii";

class EkranTalii extends Component {
    static displayName = "EkranTalii";
    static navigationOptions = {title: "Wszyskie talie"};

    constructor(props) {
        super(props);
        this.state = {talie: MakietyTalii};
    }

    stworzTalie = () => {
        console.warn("Zapisywanie danych nie zaimplementowane");
        this.props.navigation.navigate("StworzNowaKarte");
    };

    dodajKarte = () => {
        console.warn("Zapisywanie danych nie zaimplementowane");
        this.props.navigation.navigate("StworzNowaKarte");
    };

    powtorka = () => {
        console.warn("Zapisywanie danych nie zaimplementowane");
        this.props.navigation.navigate("Powtorka");
    };

    stworzWidokTalii() {
        if (!this.state.talie) {
            return null;
        }

        return this.state.talie.map(talia => {
            return <Talia
                talia={talia}
                ilosc={talia.karty.length}
                key={talia.id}
                dodajKarte={this.dodajKarte}
                powtorka={this.powtorka}
            />
        });
    }

    render() {
        return (
            <View>
                {this.stworzWidokTalii()}
                <TworzenieTalii stworz={this.stworzTalie}/>
            </View>
        );
    }
}

export default EkranTalii;
