import { AsyncStorage } from "react-native";
import Talia from "./../dane/Talia";
export const KLUCZ_TALII = "fiszki:talie";
import { MakietyTalii } from "./../dane/Makiety";

async function odczytaj(klucz, deserializator) {
  try {
    let wartosc = await AsyncStorage.getItem(klucz);
    if (wartosc !== null) {
      let readValue = JSON.parse(wartosc).map(zserializowane => {

        return deserializator(zserializowane);
      });
      return readValue;
    } else {
      console.info(` Talia o kluczu ${klucz} nie została znaleziona na dysku.`);
      return [];
    }
  } catch (error) {
    console.warn("Błąd AsyncStorage: ", error.message);
  }
}

async function zapisz(klucz, element) {
  try {
    await AsyncStorage.setItem(klucz, JSON.stringify(element));
  } catch (blad) {
    console.error("Błąd AsyncStorage: ", blad.message);
  }
}

export const zaladujTalie = () => {
  return odczytaj(KLUCZ_TALII, Talia.zObiektu);
};

export const zapisTalii = talie => {
  return zapisz(KLUCZ_TALII, talie);
};

// W celach testowych/do debugowania
//const DaneDoZastapienia = zapisTalii(MakietyTalii);
