import { stworzPowtorke } from "./../dane/WidokKartQuizu";
import { POWTORKA_TALIE, NASTEPNA_POWTORKA, KONIEC_POWTORKI} from "../akcje/typy";

export const utworzStanPowtorki = (
    idTalii = null,
    pytania = [],
    indeksObecnegoPytania = 0
) => {
  return { idTalii: idTalii, pytania: pytania, indeksObecnegoPytania: indeksObecnegoPytania };
};

function znajdzTalie(talie, id) {
  return talie.find(d => {
    return d.id === id;
  });
}

function utworzPowtorke(talia) {
  return utworzStanPowtorki(talia.id, stworzPowtorke(talia.karty), 0);
}

function nastepnaPowtorka(stan) {
  return utworzStanPowtorki(
    stan.idTalii,
    stan.pytania,
    stan.indeksObecnegoPytania + 1
  );
}

const reduktor = (stan = utworzStanPowtorki(), akcja, talie) => {
  switch (akcja.type) {
    case POWTORKA_TALIE:
      return utworzPowtorke(znajdzTalie(talie, akcja.dane.idTalii));
    case NASTEPNA_POWTORKA:
      return nastepnaPowtorka(stan);
    case KONIEC_POWTORKI:
      return utworzStanPowtorki();
  }
  return stan;
};

export default reduktor;
