import React, { Component } from "react";
import { StyleSheet, TextInput, View } from "react-native";

import colors from "../style/kolory";
import { czcionka } from "../style/czcionka";

class Wejscie extends Component {
  constructor(props) {
    super(props);
    this.state = { text: "" };
  }

  utworz = () => {
    this.props.naWpis(this.state.text);
    this.setState({ tekst: "" });
  };

  naZatwierdzenie = zdarzenie => {
    this.props.naWpis(zdarzenie.nativeEvent.text);
    if (this.props.wyczyscNaZatwierdzeniu) {
      this.setState({ tekst: "" });
    }
  };

  naZmiane = tekst => {
    this.setState({ tekst: tekst });
    if (this.props.naZmiane) {
      this.props.naZmiane(tekst);
    }
  };

  render() {
    return (
      <TextInput
        style={[
          styles.nazwaPola,
          styles.szerokiPrzycisk,
          czcionka.normalna,
          this.props.style
        ]}
        ref="PoleNowejTalii"
        multiline={false}
        autoCorrect={false}
        onChangeText={this.naZmiane}
        onSubmitEditing={this.naZatwierdzenie}
      />
    );
  }
}

// Default props are used if not otherwise specified
Wejscie.defaultProps = { wyczyscNaZatwierdzeniu: false };

export default Wejscie;

const styles = StyleSheet.create({
  nazwaPola: { backgroundColor: colors.tan, height: 60 },
  szerokiPrzycisk: { justifyContent: "center", padding: 10, margin: 10 }
});
