import React, {Component} from "react";
import {StyleSheet, View} from "react-native";

import Button from "../Button";
import PodpisaneWejscie from "../PodpisaneWejscie";
import NormalnyTekst from "../NormalnyTekst";
import colors from "../../style/kolory";

import {dodajKarte} from "../../akcje/kreatory";
import {connect} from "react-redux";
import {powtorkaTalii} from "../../akcje/kreatory";

class NowaKarta extends Component {
    static navigationOptions = {title: "Stwórz Kartę"};
    static stanPoczątkowy = {przod: "", tyl: ""};

    idTalii = () => {
        return this.props.navigation.state.params.idTalii;
    };

    constructor(props) {
        super(props);
        this.state = this.stanPoczątkowy;
    }

    zmienPrzod = tekst => {
        this.setState({przod: tekst});
    };

    zmienTyl = tekst => {
        this.setState({tyl: tekst});
    };

    stworzKarte = () => {
        this.props.stworzKarte(this.state.przod, this.state.tyl, this.idTalii());
        this.props.navigation.navigate("StworzNowaKarte", {idTalii: this.idTalii()});
    };

    powtorkaTalii = () => {
        this.props.powtorkaTalii(this.idTalii());
        this.props.navigation.navigate("Powtorka");
    };

    zakonczTworzenieKart = () => {
        this.props.navigation.navigate("EkranGlowny");
    };

    render() {
        return (
            <View>
                <PodpisaneWejscie
                    tekst="Przód"
                    wyczyscNaZatwierdzeniu={false}
                    naWpis={this.zmienPrzod}
                    naZmiane={this.zmienPrzod}
                />
                <PodpisaneWejscie
                    tekst="Tyl"
                    wyczyscNaZatwierdzeniu={false}
                    naWpis={this.zmienTyl}
                    naZmiane={this.zmienTyl}
                />

                <Button style={styles.przyciskTworzenia} naNacisniecie={this.stworzKarte}>
                    <NormalnyTekst>Stwórz kartę</NormalnyTekst>
                </Button>

                <View style={styles.wierszPrzycisku}>
                    <Button style={styles.dodatkowyPrzycistk} naNacisniecie={this.zakonczTworzenieKart}>
                        <NormalnyTekst>Zakończ</NormalnyTekst>
                    </Button>

                    <Button style={styles.dodatkowyPrzycistk} naNacisniecie={this.powtorkaTalii}>
                        <NormalnyTekst>Powtorka talii</NormalnyTekst>
                    </Button>
                </View>
            </View>
        );
    }
}

const styles = StyleSheet.create({
    przyciskTworzenia: {backgroundColor: colors.green},
    dodatkowyPrzycistk: {backgroundColor: colors.blue},
    wierszPrzycisku: {flexDirection: "row"}
});
const mapujStanDoAtrybutow = state => {
    return {talie: state.talie};
};

const mapujWykonanieDoAtrybutow = wykonaj => {
    return {
        stworzKarte: (przod, tyl, idTalii) => {
            wykonaj(dodajKarte(przod, tyl, idTalii));
        },
        powtorkaTalii: idTalii => {
            wykonaj(powtorkaTalii(idTalii));
        }
    };
};

export default connect(mapujStanDoAtrybutow, mapujWykonanieDoAtrybutow)(NowaKarta);