import React, {Component} from "react";
import {View} from "react-native";

import Talia from "./Talia";
import TworzenieTalii from "./TworzenieTalii";
import { connect } from "react-redux";
import {dodajTalie,powtorkaTalii} from "../../akcje/kreatory"
class EkranTalii extends Component {
    static displayName = "EkranPowtorki";
    static navigationOptions = {title: "Wszyskie talie"};

    stworzTalie = (nazwa) => {
        let akcjaTworzeniaTalii = dodajTalie(nazwa);
           this.props.stworzTalie(akcjaTworzeniaTalii);
            this.props.navigation.navigate("StworzNowaKarte", {
              idTalii: akcjaTworzeniaTalii.dane.id
           });
    };

    dodajKarte = (idTalii) => {
        this.props.navigation.navigate("StworzNowaKarte",{idTalii:idTalii});
    };

    powtorka = (idTalii) => {
        this.props.powtorzTalie(idTalii);
        this.props.navigation.navigate("Powtorka");
    };

    stworzWidokTalii() {
        if (!this.props.talie) {
            return null;
        }

        return this.props.talie.map(talia => {
            return <Talia
                talia={talia}
                ilosc={this.props.ilosc[talia.id]}
                key={talia.id}
                dodajKarte={() => {
                    this.dodajKarte(talia.id);
                }}
                powtorka={() => {
                    this.powtorka(talia.id);
                }}
            />
        });
    }

    render() {
        return (
            <View>
                {this.stworzWidokTalii()}
                <TworzenieTalii stworz={this.stworzTalie}/>
            </View>
        );
    }
}

const mapujWykonanieDoAtrybutow = wykonaj => {
  return {
    stworzTalie: akcjaNaTaliach => {
      wykonaj(akcjaNaTaliach);
    },
    powtorzTalie: idTalii => {
      wykonaj(powtorkaTalii(idTalii));
    }
  };
};

const mapujStanDoAtrybutow = stan => {
  return {
    talie: stan.talie,
    ilosc: stan.talie.reduce(
      (suma, talia) => {
        suma[talia.id] = talia.karty.length;
        return suma;
      },
      {}
    )
  };
};

export default connect(mapujStanDoAtrybutow, mapujWykonanieDoAtrybutow)(EkranTalii);
