import React, {Component} from "react";
import {StyleSheet, View} from "react-native";

import Button from "../Button";
import PodpisaneWejscie from "../PodpisaneWejscie";
import NormalnyTekst from "../NormalnyTekst";
import colors from "../../style/kolory";

export default class NowaKarta extends Component {
    constructor(props) {
        super(props);
        this.state = {przod: "", tyl: ""};
    }

    zmienPrzod = tekst => {
        this.setState({przod: tekst});
    };

    zmienTyl = tekst => {
        this.setState({tyl: tekst});
    };

    stworzKarte = () => {
        console.warn("Nie zaimplementowano");
    };

    powtorkaTalii = () => {
        console.warn("Nie zaimplementowano");
    };

    zakonczTworzenieKart = () => {
        console.warn("Nie zaimplementowano");
    };

    render() {
        return (
            <View>
                <PodpisaneWejscie
                    tekst="Przód"
                    wyczyscNaZatwierdzeniu={false}
                    naWpis={this.zmienPrzod}
                    naZmiane={this.zmienPrzod}
                />
                <PodpisaneWejscie
                    tekst="Tyl"
                    wyczyscNaZatwierdzeniu={false}
                    naWpis={this.zmienTyl}
                    naZmiane={this.zmienTyl}
                />

                <Button style={styles.przyciskTworzenia} naNacisniecie={this.stworzKarte}>
                    <NormalnyTekst>Stwórz kartę</NormalnyTekst>
                </Button>

                <View style={styles.wierszPrzycisku}>
                    <Button style={styles.dodatkowyPrzycistk} naNacisniecie={this.zakonczTworzenieKart}>
                        <NormalnyTekst>Zakończ</NormalnyTekst>
                    </Button>

                    <Button style={styles.dodatkowyPrzycistk} naNacisniecie={this.powtorkaTalii}>
                        <NormalnyTekst>Powtorka talii</NormalnyTekst>
                    </Button>
                </View>
            </View>
        );
    }
}

const styles = StyleSheet.create({
    przyciskTworzenia: {backgroundColor: colors.green},
    dodatkowyPrzycistk: {backgroundColor: colors.blue},
    wierszPrzycisku: {flexDirection: "row"}
});
