import React, { Component } from "react";

import { StyleSheet, Text, View, TextInput } from "react-native";

export default class ProjektPogodynka extends Component<{}> {
  constructor(props) {
    super(props);
    this.state = { kod: "" };
  }

  _handleTextChange = event => {
    this.setState({ kod: event.nativeEvent.text });
  };

  render() {
    return (
      <View style={styles.kontener}>
        <Text style={styles.witaj}>
          Wpisałeś {this.state.kod}.
        </Text>
        <TextInput
          style={styles.wejscie}
          onSubmitEditing={this._handleTextChange}
        />
      </View>
    );
  }
}

const styles = StyleSheet.create({
  kontener: {
    flex: 1,
    justifyContent: "center",
    alignItems: "center",
    backgroundColor: "#F5FCFF"
  },
  witaj: { fontSize: 20, textAlign: "center", margin: 10 },
  wejscie: {
    fontSize: 20,
    borderWidth: 2,
    padding: 2,
    height: 40,
    width: 100,
    textAlign: "center"
  }
});
