import React, {Component} from "react";
import {StyleSheet, View} from "react-native";

import PodgladKart from "./PodgladKart";
import {MakietaPowtorki} from "../../dane/Makiety";
import {utworzPodsumowanie} from "./PodsumowaniePowtorki";
import colors from "../../style/kolory";
import {powtorkaTalii, nastepnaPowtorka, koniecPowtorki} from "../../akcje/kreatory";
import {connect} from "react-redux";

class EkranPowtorki extends Component {
    static displayName = "EkranPowtorki";
    static navigationOptions = {title: "Powtorka"};

    constructor(props) {
        super(props);
        this.state = {
            iloscPrzejrzanych: 0,
            iloscPoprawnych: 0
        };
    }

    naAkcje = poprawnosc => {
        if (poprawnosc) {
            this.setState({iloscPoprawnych: this.state.iloscPoprawnych + 1});
        }
        this.setState({iloscPrzejrzanych: this.state.iloscPrzejrzanych + 1});
    };

    nastepnaDoPowtorki = () => {
        this.props.nastepnaPowtorka();
    };

    wyjdzZPowtorki = () => {
        this.props.koniecPowtorki();
        this.props.navigation.goBack();
    };

    zawartosc() {
        if (!this.props.powtorka || this.props.powtorka.length === 0) {
            return null;
        }

        if (this.props.obecnaPowtorka < this.props.powtorka.length) {
            return (
                <PodgladKart
                    naAkcje={this.naAkcje}
                    kontynuuj={this.nastepnaDoPowtorki}
                    wyjdz={this.wyjdzZPowtorki}
                    {...this.props.powtorka[this.props.obecnaPowtorka]}
                />
            );
        } else {
            let procenty = this.state.iloscPoprawnych / this.state.iloscPrzejrzanych;
            return utworzPodsumowanie(procenty, this.wyjdzZPowtorki);
        }
    }

    render() {
        return (
            <View style={styles.kontener}>
                {this.zawartosc()}
            </View>
        );
    }
}

const styles = StyleSheet.create({
    kontener: {backgroundColor: colors.blue, flex: 1, paddingTop: 24}
});

const mapujWykonanieDoAtrybutow = wykonaj => {
    return {
        nastepnaPowtorka: () => {
            wykonaj(nastepnaPowtorka());
        },
        koniecPowtorki: () => {
            wykonaj(koniecPowtorki());
        }
    };
};

const mapujStanDoAtrybutow = stan => {
    return {
        powtorka: stan.obecnaPowtorka.pytania,
        obecnaPowtorka: stan.obecnaPowtorka.indeksObecnegoPytania
    };
};

export default connect(mapujStanDoAtrybutow, mapujWykonanieDoAtrybutow)(EkranPowtorki);
