import React, {Component} from "react";
import {View} from "react-native";

import TekstNaglowka from "./../TekstNaglowka";
import {utworzPrzyciskiKontynuacjiIWyjscia, utworzPrzyciskiOdpowiedzi} from "./GuzikiPowtorki";

class PodgladKart extends Component {
    static displayName = "PodgladKart";

    pobierzOryginalnyStan() {
        return {pokazujOdpowiedzi: false, byloPoprawne: false};
    }

    constructor(props) {
        super(props);
        this.state = this.pobierzOryginalnyStan();
    }

    kontynuuj = () => {
        this.setState(this.pobierzOryginalnyStan());
        this.props.kontynuuj();
    };

    wybranaOdpowiedz = poprawnosc => {
        this.props.naAkcje(poprawnosc);
        this.setState({pokazujOdpowiedzi: true, byloPoprawne: poprawnosc});
    };

    render() {
        return (
            <View>
                <TekstNaglowka>
                    {this.props.podpowiedz}
                </TekstNaglowka>
                {utworzPrzyciskiOdpowiedzi(
                    this.props.odpowiedz,
                    this.props.poprawnaOdpowiedz,
                    this.state.pokazujOdpowiedzi,
                    this.state.byloPoprawne,
                    this.wybranaOdpowiedz
                )}
                {utworzPrzyciskiKontynuacjiIWyjscia(
                    this.state.pokazujOdpowiedzi,
                    this.state.byloPoprawne,
                    this.kontynuuj,
                    this.props.wyjdz
                )}
            </View>
        );
    }
}

export default PodgladKart;
