/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.util.SparseIntArray;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.BasePool;
import com.facebook.imagepipeline.memory.NativeMemoryChunk;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class NativeMemoryChunkPool
extends BasePool<NativeMemoryChunk> {
    private final int[] mBucketSizes;

    public NativeMemoryChunkPool(MemoryTrimmableRegistry memoryTrimmableRegistry, PoolParams poolParams, PoolStatsTracker nativeMemoryChunkPoolStatsTracker) {
        super(memoryTrimmableRegistry, poolParams, nativeMemoryChunkPoolStatsTracker);
        SparseIntArray bucketSizes = poolParams.bucketSizes;
        this.mBucketSizes = new int[bucketSizes.size()];
        for (int i = 0; i < this.mBucketSizes.length; ++i) {
            this.mBucketSizes[i] = bucketSizes.keyAt(i);
        }
        this.initialize();
    }

    public int getMinBufferSize() {
        return this.mBucketSizes[0];
    }

    @Override
    protected NativeMemoryChunk alloc(int bucketedSize) {
        return new NativeMemoryChunk(bucketedSize);
    }

    @Override
    protected void free(NativeMemoryChunk value) {
        Preconditions.checkNotNull((Object)value);
        value.close();
    }

    @Override
    protected int getSizeInBytes(int bucketedSize) {
        return bucketedSize;
    }

    @Override
    protected int getBucketedSize(int requestSize) {
        int intRequestSize = requestSize;
        if (intRequestSize <= 0) {
            throw new BasePool.InvalidSizeException(requestSize);
        }
        for (int bucketedSize : this.mBucketSizes) {
            if (bucketedSize < intRequestSize) continue;
            return bucketedSize;
        }
        return requestSize;
    }

    @Override
    protected int getBucketedSizeForValue(NativeMemoryChunk value) {
        Preconditions.checkNotNull((Object)value);
        return value.getSize();
    }

    @Override
    protected boolean isReusable(NativeMemoryChunk value) {
        Preconditions.checkNotNull((Object)value);
        return !value.isClosed();
    }
}

