/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageformat;

import com.facebook.common.internal.ByteStreams;
import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Throwables;
import com.facebook.imageformat.DefaultImageFormatChecker;
import com.facebook.imageformat.ImageFormat;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nullable;

public class ImageFormatChecker {
    private static ImageFormatChecker sInstance;
    private int mMaxHeaderLength;
    @Nullable
    private List<ImageFormat.FormatChecker> mCustomImageFormatCheckers;
    private final ImageFormat.FormatChecker mDefaultFormatChecker = new DefaultImageFormatChecker();

    private ImageFormatChecker() {
        this.updateMaxHeaderLength();
    }

    public void setCustomImageFormatCheckers(@Nullable List<ImageFormat.FormatChecker> customImageFormatCheckers) {
        this.mCustomImageFormatCheckers = customImageFormatCheckers;
        this.updateMaxHeaderLength();
    }

    public ImageFormat determineImageFormat(InputStream is) throws IOException {
        ImageFormat format;
        Preconditions.checkNotNull((Object)is);
        byte[] imageHeaderBytes = new byte[this.mMaxHeaderLength];
        int headerSize = ImageFormatChecker.readHeaderFromStream(this.mMaxHeaderLength, is, imageHeaderBytes);
        if (this.mCustomImageFormatCheckers != null) {
            for (ImageFormat.FormatChecker formatChecker : this.mCustomImageFormatCheckers) {
                ImageFormat format2 = formatChecker.determineFormat(imageHeaderBytes, headerSize);
                if (format2 == null || format2 == ImageFormat.UNKNOWN) continue;
                return format2;
            }
        }
        if ((format = this.mDefaultFormatChecker.determineFormat(imageHeaderBytes, headerSize)) == null) {
            format = ImageFormat.UNKNOWN;
        }
        return format;
    }

    private void updateMaxHeaderLength() {
        this.mMaxHeaderLength = this.mDefaultFormatChecker.getHeaderSize();
        if (this.mCustomImageFormatCheckers != null) {
            for (ImageFormat.FormatChecker checker : this.mCustomImageFormatCheckers) {
                this.mMaxHeaderLength = Math.max(this.mMaxHeaderLength, checker.getHeaderSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int readHeaderFromStream(int maxHeaderLength, InputStream is, byte[] imageHeaderBytes) throws IOException {
        Preconditions.checkNotNull((Object)is);
        Preconditions.checkNotNull((Object)imageHeaderBytes);
        Preconditions.checkArgument((imageHeaderBytes.length >= maxHeaderLength ? 1 : 0) != 0);
        if (is.markSupported()) {
            try {
                is.mark(maxHeaderLength);
                int n = ByteStreams.read((InputStream)is, (byte[])imageHeaderBytes, (int)0, (int)maxHeaderLength);
                return n;
            }
            finally {
                is.reset();
            }
        }
        return ByteStreams.read((InputStream)is, (byte[])imageHeaderBytes, (int)0, (int)maxHeaderLength);
    }

    public static synchronized ImageFormatChecker getInstance() {
        if (sInstance == null) {
            sInstance = new ImageFormatChecker();
        }
        return sInstance;
    }

    public static ImageFormat getImageFormat(InputStream is) throws IOException {
        return ImageFormatChecker.getInstance().determineImageFormat(is);
    }

    public static ImageFormat getImageFormat_WrapIOException(InputStream is) {
        try {
            return ImageFormatChecker.getImageFormat(is);
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFormat getImageFormat(String filename) {
        ImageFormat imageFormat;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filename);
            imageFormat = ImageFormatChecker.getImageFormat(fileInputStream);
        }
        catch (IOException ioe) {
            ImageFormat imageFormat2;
            try {
                imageFormat2 = ImageFormat.UNKNOWN;
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fileInputStream);
                throw throwable;
            }
            Closeables.closeQuietly((InputStream)fileInputStream);
            return imageFormat2;
        }
        Closeables.closeQuietly((InputStream)fileInputStream);
        return imageFormat;
    }
}

