/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.StrictMode;
import android.text.TextUtils;
import com.facebook.soloader.ApkSoSource;
import com.facebook.soloader.DirectorySoSource;
import com.facebook.soloader.ExoSoSource;
import com.facebook.soloader.NoopSoSource;
import com.facebook.soloader.SoSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class SoLoader {
    static final String TAG = "SoLoader";
    static final boolean DEBUG = false;
    static final boolean SYSTRACE_LIBRARY_LOADING = false;
    @Nullable
    private static SoSource[] sSoSources = null;
    private static final Set<String> sLoadedLibraries = new HashSet<String>();
    @Nullable
    private static StrictMode.ThreadPolicy sOldPolicy = null;
    private static String SO_STORE_NAME_MAIN = "lib-main";
    public static final int SOLOADER_ENABLE_EXOPACKAGE = 1;
    public static final int SOLOADER_ALLOW_ASYNC_INIT = 2;
    private static int sFlags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context, int flags) throws IOException {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            SoLoader.initImpl(context, flags);
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
    }

    public static void init(Context context, boolean nativeExopackage) {
        try {
            SoLoader.init(context, nativeExopackage ? 1 : 0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static synchronized void initImpl(Context context, int flags) throws IOException {
        if (sSoSources == null) {
            sFlags = flags;
            ArrayList<DirectorySoSource> soSources = new ArrayList<DirectorySoSource>();
            String LD_LIBRARY_PATH = System.getenv("LD_LIBRARY_PATH");
            if (LD_LIBRARY_PATH == null) {
                LD_LIBRARY_PATH = "/vendor/lib:/system/lib";
            }
            String[] systemLibraryDirectories = LD_LIBRARY_PATH.split(":");
            for (int i = 0; i < systemLibraryDirectories.length; ++i) {
                File systemSoDirectory = new File(systemLibraryDirectories[i]);
                soSources.add(new DirectorySoSource(systemSoDirectory, 2));
            }
            if (context != null) {
                if ((flags & 1) != 0) {
                    soSources.add(0, new ExoSoSource(context, SO_STORE_NAME_MAIN));
                } else {
                    int apkSoSourceFlags;
                    boolean isSystemApplication;
                    ApplicationInfo applicationInfo = context.getApplicationInfo();
                    boolean bl = isSystemApplication = (applicationInfo.flags & 1) != 0 && (applicationInfo.flags & 0x80) == 0;
                    if (isSystemApplication) {
                        apkSoSourceFlags = 0;
                    } else {
                        apkSoSourceFlags = 1;
                        int ourSoSourceFlags = 0;
                        if (Build.VERSION.SDK_INT <= 17) {
                            ourSoSourceFlags |= 1;
                        }
                        DirectorySoSource ourSoSource = new DirectorySoSource(new File(applicationInfo.nativeLibraryDir), ourSoSourceFlags);
                        soSources.add(0, ourSoSource);
                    }
                    soSources.add(0, new ApkSoSource(context, SO_STORE_NAME_MAIN, apkSoSourceFlags));
                }
            }
            SoSource[] finalSoSources = soSources.toArray(new SoSource[soSources.size()]);
            int prepareFlags = SoLoader.makePrepareFlags();
            int i = finalSoSources.length;
            while (i-- > 0) {
                finalSoSources[i].prepare(prepareFlags);
            }
            sSoSources = finalSoSources;
        }
    }

    private static int makePrepareFlags() {
        int prepareFlags = 0;
        if ((sFlags & 2) != 0) {
            prepareFlags |= 1;
        }
        return prepareFlags;
    }

    public static void setInTestMode() {
        sSoSources = new SoSource[]{new NoopSoSource()};
    }

    public static synchronized void loadLibrary(String shortName) throws UnsatisfiedLinkError {
        if (sSoSources == null) {
            if ("http://www.android.com/".equals(System.getProperty("java.vendor.url"))) {
                SoLoader.assertInitialized();
            } else {
                System.loadLibrary(shortName);
                return;
            }
        }
        try {
            SoLoader.loadLibraryBySoName(System.mapLibraryName(shortName), 0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (UnsatisfiedLinkError ex) {
            String message = ex.getMessage();
            if (message != null && message.contains("unexpected e_machine:")) {
                throw new WrongAbiError(ex);
            }
            throw ex;
        }
    }

    public static File unpackLibraryAndDependencies(String shortName) throws UnsatisfiedLinkError {
        SoLoader.assertInitialized();
        try {
            return SoLoader.unpackLibraryBySoName(System.mapLibraryName(shortName));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryBySoName(String soName, int loadFlags) throws IOException {
        int result;
        int n = result = sLoadedLibraries.contains(soName) ? 1 : 0;
        if (result == 0) {
            boolean restoreOldPolicy = false;
            if (sOldPolicy == null) {
                sOldPolicy = StrictMode.allowThreadDiskReads();
                restoreOldPolicy = true;
            }
            try {
                for (int i = 0; result == 0 && i < sSoSources.length; ++i) {
                    result = sSoSources[i].loadLibrary(soName, loadFlags);
                }
            }
            finally {
                if (restoreOldPolicy) {
                    StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)sOldPolicy);
                    sOldPolicy = null;
                }
            }
        }
        if (result == 0) {
            throw new UnsatisfiedLinkError("couldn't find DSO to load: " + soName);
        }
        if (result == 1) {
            sLoadedLibraries.add(soName);
        }
    }

    static File unpackLibraryBySoName(String soName) throws IOException {
        for (int i = 0; i < sSoSources.length; ++i) {
            File unpacked = sSoSources[i].unpackLibrary(soName);
            if (unpacked == null) continue;
            return unpacked;
        }
        throw new FileNotFoundException(soName);
    }

    private static void assertInitialized() {
        if (sSoSources == null) {
            throw new RuntimeException("SoLoader.init() not yet called");
        }
    }

    public static synchronized void prependSoSource(SoSource extraSoSource) throws IOException {
        SoLoader.assertInitialized();
        extraSoSource.prepare(SoLoader.makePrepareFlags());
        SoSource[] newSoSources = new SoSource[sSoSources.length + 1];
        newSoSources[0] = extraSoSource;
        System.arraycopy(sSoSources, 0, newSoSources, 1, sSoSources.length);
        sSoSources = newSoSources;
    }

    public static synchronized String makeLdLibraryPath() {
        SoLoader.assertInitialized();
        ArrayList<String> pathElements = new ArrayList<String>();
        SoSource[] soSources = sSoSources;
        for (int i = 0; i < soSources.length; ++i) {
            soSources[i].addToLdLibraryPath(pathElements);
        }
        return TextUtils.join((CharSequence)":", pathElements);
    }

    public static final class WrongAbiError
    extends UnsatisfiedLinkError {
        WrongAbiError(Throwable cause) {
            super("APK was built for a different platform");
            this.initCause(cause);
        }
    }
}

