/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.progressbar;

import android.content.Context;
import android.util.SparseIntArray;
import android.view.View;
import android.widget.ProgressBar;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.progressbar.ReactProgressBarViewManager;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class ProgressBarShadowNode
extends LayoutShadowNode
implements YogaMeasureFunction {
    private String mStyle = "Normal";
    private final SparseIntArray mHeight;
    private final SparseIntArray mWidth;
    private final Set<Integer> mMeasured;

    public ProgressBarShadowNode() {
        this.mHeight = new SparseIntArray();
        this.mWidth = new SparseIntArray();
        this.mMeasured = new HashSet<Integer>();
        this.setMeasureFunction(this);
    }

    public ProgressBarShadowNode(ProgressBarShadowNode node) {
        super(node);
        this.mWidth = node.mWidth.clone();
        this.mHeight = node.mHeight.clone();
        this.mMeasured = new HashSet<Integer>(node.mMeasured);
        this.setMeasureFunction(this);
    }

    @Override
    public ProgressBarShadowNode mutableCopy() {
        return new ProgressBarShadowNode(this);
    }

    @Nullable
    public String getStyle() {
        return this.mStyle;
    }

    @ReactProp(name="styleAttr")
    public void setStyle(@Nullable String style) {
        this.mStyle = style == null ? "Normal" : style;
    }

    @Override
    public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        int style = ReactProgressBarViewManager.getStyleFromString(this.getStyle());
        if (!this.mMeasured.contains(style)) {
            ProgressBar progressBar = ReactProgressBarViewManager.createProgressBar((Context)this.getThemedContext(), style);
            int spec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
            progressBar.measure(spec, spec);
            this.mHeight.put(style, progressBar.getMeasuredHeight());
            this.mWidth.put(style, progressBar.getMeasuredWidth());
            this.mMeasured.add(style);
        }
        return YogaMeasureOutput.make(this.mWidth.get(style), this.mHeight.get(style));
    }
}

