/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.art;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.ReactShadowNodeImpl;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.art.PropHelper;
import javax.annotation.Nullable;

public abstract class ARTVirtualNode
extends ReactShadowNodeImpl {
    protected static final float MIN_OPACITY_FOR_DRAW = 0.01f;
    private static final float[] sMatrixData = new float[9];
    private static final float[] sRawMatrix = new float[9];
    protected float mOpacity = 1.0f;
    @Nullable
    private Matrix mMatrix = new Matrix();
    protected final float mScale;

    public ARTVirtualNode() {
        this.mScale = DisplayMetricsHolder.getWindowDisplayMetrics().density;
    }

    protected ARTVirtualNode(ARTVirtualNode artVirtualNode) {
        super(artVirtualNode);
        this.mScale = artVirtualNode.mScale;
        this.mOpacity = artVirtualNode.mOpacity;
        this.mMatrix = new Matrix(artVirtualNode.mMatrix);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public abstract void draw(Canvas var1, Paint var2, float var3);

    protected final void saveAndSetupCanvas(Canvas canvas) {
        canvas.save();
        if (this.mMatrix != null) {
            canvas.concat(this.mMatrix);
        }
    }

    protected void restoreCanvas(Canvas canvas) {
        canvas.restore();
    }

    @ReactProp(name="opacity", defaultFloat=1.0f)
    public void setOpacity(float opacity) {
        this.mOpacity = opacity;
        this.markUpdated();
    }

    @ReactProp(name="transform")
    public void setTransform(@Nullable ReadableArray transformArray) {
        if (transformArray != null) {
            int matrixSize = PropHelper.toFloatArray(transformArray, sMatrixData);
            if (matrixSize == 6) {
                this.setupMatrix();
            } else if (matrixSize != -1) {
                throw new JSApplicationIllegalArgumentException("Transform matrices must be of size 6");
            }
        } else {
            this.mMatrix = null;
        }
        this.markUpdated();
    }

    protected void setupMatrix() {
        ARTVirtualNode.sRawMatrix[0] = sMatrixData[0];
        ARTVirtualNode.sRawMatrix[1] = sMatrixData[2];
        ARTVirtualNode.sRawMatrix[2] = sMatrixData[4] * this.mScale;
        ARTVirtualNode.sRawMatrix[3] = sMatrixData[1];
        ARTVirtualNode.sRawMatrix[4] = sMatrixData[3];
        ARTVirtualNode.sRawMatrix[5] = sMatrixData[5] * this.mScale;
        ARTVirtualNode.sRawMatrix[6] = 0.0f;
        ARTVirtualNode.sRawMatrix[7] = 0.0f;
        ARTVirtualNode.sRawMatrix[8] = 1.0f;
        if (this.mMatrix == null) {
            this.mMatrix = new Matrix();
        }
        this.mMatrix.setValues(sRawMatrix);
    }
}

