/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.util.SparseIntArray;
import com.facebook.react.flat.ClippingDrawCommandManager;
import com.facebook.react.flat.DrawCommand;
import com.facebook.react.flat.DrawView;
import com.facebook.react.flat.FlatViewGroup;
import com.facebook.react.flat.NodeRegion;
import java.util.Arrays;

final class VerticalDrawCommandManager
extends ClippingDrawCommandManager {
    VerticalDrawCommandManager(FlatViewGroup flatViewGroup, DrawCommand[] drawCommands) {
        super(flatViewGroup, drawCommands);
    }

    @Override
    int commandStartIndex() {
        int start = Arrays.binarySearch(this.mCommandMaxBottom, (float)this.mClippingRect.top);
        return start < 0 ? ~start : start;
    }

    @Override
    int commandStopIndex(int start) {
        int stop = Arrays.binarySearch(this.mCommandMinTop, start, this.mCommandMinTop.length, (float)this.mClippingRect.bottom);
        return stop < 0 ? ~stop : stop;
    }

    @Override
    int regionStopIndex(float touchX, float touchY) {
        int stop = Arrays.binarySearch(this.mRegionMinTop, touchY + 1.0E-4f);
        return stop < 0 ? ~stop : stop;
    }

    @Override
    boolean regionAboveTouch(int index, float touchX, float touchY) {
        return this.mRegionMaxBottom[index] < touchY;
    }

    public static void fillMaxMinArrays(NodeRegion[] regions, float[] maxBottom, float[] minTop) {
        int i;
        float last = 0.0f;
        for (i = 0; i < regions.length; ++i) {
            maxBottom[i] = last = Math.max(last, regions[i].getTouchableBottom());
        }
        for (i = regions.length - 1; i >= 0; --i) {
            minTop[i] = last = Math.min(last, regions[i].getTouchableTop());
        }
    }

    public static void fillMaxMinArrays(DrawCommand[] commands, float[] maxBottom, float[] minTop, SparseIntArray drawViewIndexMap) {
        int i;
        float last = 0.0f;
        for (i = 0; i < commands.length; ++i) {
            if (commands[i] instanceof DrawView) {
                DrawView drawView = (DrawView)commands[i];
                drawViewIndexMap.append(drawView.reactTag, i);
                last = Math.max(last, drawView.mLogicalBottom);
            } else {
                last = Math.max(last, commands[i].getBottom());
            }
            maxBottom[i] = last;
        }
        for (i = commands.length - 1; i >= 0; --i) {
            last = commands[i] instanceof DrawView ? Math.min(last, ((DrawView)commands[i]).mLogicalTop) : Math.min(last, commands[i].getTop());
            minTop[i] = last;
        }
    }
}

