/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Rect;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.flat.DrawBorder;
import com.facebook.react.flat.FlatShadowNode;
import com.facebook.react.flat.HitSlopNodeRegion;
import com.facebook.react.flat.NodeRegion;
import com.facebook.react.flat.StateBuilder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import javax.annotation.Nullable;

final class RCTView
extends FlatShadowNode {
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3};
    @Nullable
    private DrawBorder mDrawBorder;
    boolean mRemoveClippedSubviews;
    boolean mHorizontal;
    @Nullable
    private Rect mHitSlop;

    RCTView() {
    }

    @Override
    void handleUpdateProperties(ReactStylesDiffMap styles) {
        boolean bl = this.mRemoveClippedSubviews = this.mRemoveClippedSubviews || styles.hasKey("removeClippedSubviews") && styles.getBoolean("removeClippedSubviews", false);
        if (this.mRemoveClippedSubviews) {
            this.mHorizontal = this.mHorizontal || styles.hasKey("horizontal") && styles.getBoolean("horizontal", false);
        }
        super.handleUpdateProperties(styles);
    }

    @Override
    protected void collectState(StateBuilder stateBuilder, float left, float top, float right, float bottom, float clipLeft, float clipTop, float clipRight, float clipBottom) {
        super.collectState(stateBuilder, left, top, right, bottom, clipLeft, clipTop, clipRight, clipBottom);
        if (this.mDrawBorder != null) {
            this.mDrawBorder = (DrawBorder)this.mDrawBorder.updateBoundsAndFreeze(left, top, right, bottom, clipLeft, clipTop, clipRight, clipBottom);
            stateBuilder.addDrawCommand(this.mDrawBorder);
        }
    }

    @Override
    boolean doesDraw() {
        return this.mDrawBorder != null || super.doesDraw();
    }

    @Override
    public void setBackgroundColor(int backgroundColor) {
        this.getMutableBorder().setBackgroundColor(backgroundColor);
    }

    @Override
    public void setBorderWidths(int index, float borderWidth) {
        super.setBorderWidths(index, borderWidth);
        int type = SPACING_TYPES[index];
        this.getMutableBorder().setBorderWidth(type, PixelUtil.toPixelFromDIP(borderWidth));
    }

    @ReactProp(name="nativeBackgroundAndroid")
    public void setHotspot(@Nullable ReadableMap bg) {
        if (bg != null) {
            this.forceMountToView();
        }
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color", defaultDouble=NaN)
    public void setBorderColor(int index, double color) {
        int type = SPACING_TYPES[index];
        if (Double.isNaN(color)) {
            this.getMutableBorder().resetBorderColor(type);
        } else {
            this.getMutableBorder().setBorderColor(type, (int)color);
        }
    }

    @ReactProp(name="borderRadius")
    public void setBorderRadius(float borderRadius) {
        this.mClipRadius = borderRadius;
        if (this.mClipToBounds && borderRadius > 0.5f) {
            this.forceMountToView();
        }
        this.getMutableBorder().setBorderRadius(PixelUtil.toPixelFromDIP(borderRadius));
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(@Nullable String borderStyle) {
        this.getMutableBorder().setBorderStyle(borderStyle);
    }

    @ReactProp(name="hitSlop")
    public void setHitSlop(@Nullable ReadableMap hitSlop) {
        this.mHitSlop = hitSlop == null ? null : new Rect((int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("left")), (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("top")), (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("right")), (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("bottom")));
    }

    @ReactProp(name="pointerEvents")
    public void setPointerEvents(@Nullable String pointerEventsStr) {
        this.forceMountToView();
    }

    @Override
    void updateNodeRegion(float left, float top, float right, float bottom, boolean isVirtual) {
        if (!this.getNodeRegion().matches(left, top, right, bottom, isVirtual)) {
            this.setNodeRegion(this.mHitSlop == null ? new NodeRegion(left, top, right, bottom, this.getReactTag(), isVirtual) : new HitSlopNodeRegion(this.mHitSlop, left, top, right, bottom, this.getReactTag(), isVirtual));
        }
    }

    private DrawBorder getMutableBorder() {
        if (this.mDrawBorder == null) {
            this.mDrawBorder = new DrawBorder();
        } else if (this.mDrawBorder.isFrozen()) {
            this.mDrawBorder = (DrawBorder)this.mDrawBorder.mutableCopy();
        }
        this.invalidate();
        return this.mDrawBorder;
    }

    @Override
    public boolean clipsSubviews() {
        return this.mRemoveClippedSubviews;
    }
}

