/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.flat.AbstractDrawCommand;
import com.facebook.react.flat.AttachDetachListener;
import com.facebook.react.flat.DrawCommand;
import com.facebook.react.flat.DrawCommandManager;
import com.facebook.react.flat.FlatMeasuredViewGroup;
import com.facebook.react.flat.NodeRegion;
import com.facebook.react.flat.ViewResolver;
import com.facebook.react.touch.OnInterceptTouchEventListener;
import com.facebook.react.touch.ReactHitSlopView;
import com.facebook.react.touch.ReactInterceptingViewGroup;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import com.facebook.react.uimanager.ReactCompoundViewGroup;
import com.facebook.react.uimanager.ReactPointerEventsView;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.views.image.ImageLoadEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.annotation.Nullable;

final class FlatViewGroup
extends ViewGroup
implements ReactInterceptingViewGroup,
ReactClippingViewGroup,
ReactCompoundViewGroup,
ReactHitSlopView,
ReactPointerEventsView,
FlatMeasuredViewGroup {
    private static final boolean DEBUG_DRAW_TEXT = false;
    static final boolean DEBUG_HIGHLIGHT_PERFORMANCE_ISSUES = false;
    private static final boolean DEBUG_DRAW = false;
    private boolean mAndroidDebugDraw;
    private static Paint sDebugTextPaint;
    private static Paint sDebugTextBackgroundPaint;
    private static Paint sDebugRectPaint;
    private static Paint sDebugCornerPaint;
    private static Rect sDebugRect;
    private static final ArrayList<FlatViewGroup> LAYOUT_REQUESTS;
    private static final Rect VIEW_BOUNDS;
    @Nullable
    private InvalidateCallback mInvalidateCallback;
    private DrawCommand[] mDrawCommands = DrawCommand.EMPTY_ARRAY;
    private AttachDetachListener[] mAttachDetachListeners = AttachDetachListener.EMPTY_ARRAY;
    private NodeRegion[] mNodeRegions = NodeRegion.EMPTY_ARRAY;
    private int mDrawChildIndex = 0;
    private boolean mIsAttached = false;
    private boolean mIsLayoutRequested = false;
    private boolean mNeedsOffscreenAlphaCompositing = false;
    private Drawable mHotspot;
    private PointerEvents mPointerEvents = PointerEvents.AUTO;
    private long mLastTouchDownTime;
    @Nullable
    private OnInterceptTouchEventListener mOnInterceptTouchEventListener;
    private static final SparseArray<View> EMPTY_DETACHED_VIEWS;
    @Nullable
    private DrawCommandManager mDrawCommandManager;
    @Nullable
    private Rect mHitSlopRect;

    FlatViewGroup(Context context) {
        super(context);
        this.setClipChildren(false);
    }

    protected void detachAllViewsFromParent() {
        super.detachAllViewsFromParent();
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void requestLayout() {
        if (this.mIsLayoutRequested) {
            return;
        }
        this.mIsLayoutRequested = true;
        LAYOUT_REQUESTS.add(this);
    }

    @Override
    public int reactTagForTouch(float touchX, float touchY) {
        NodeRegion nodeRegion;
        SoftAssertions.assertCondition(this.mPointerEvents != PointerEvents.NONE, "TouchTargetHelper should not allow calling this method when pointer events are NONE");
        if (this.mPointerEvents != PointerEvents.BOX_ONLY && (nodeRegion = this.virtualNodeRegionWithinBounds(touchX, touchY)) != null) {
            return nodeRegion.getReactTag(touchX, touchY);
        }
        return this.getId();
    }

    @Override
    public boolean interceptsTouchEvent(float touchX, float touchY) {
        NodeRegion nodeRegion = this.anyNodeRegionWithinBounds(touchX, touchY);
        return nodeRegion != null && nodeRegion.mIsVirtual;
    }

    protected void onDebugDraw(Canvas canvas) {
        this.mAndroidDebugDraw = true;
    }

    public void dispatchDraw(Canvas canvas) {
        this.mAndroidDebugDraw = false;
        super.dispatchDraw(canvas);
        if (this.mDrawCommandManager != null) {
            this.mDrawCommandManager.draw(canvas);
        } else {
            for (DrawCommand drawCommand : this.mDrawCommands) {
                drawCommand.draw(this, canvas);
            }
        }
        if (this.mDrawChildIndex != this.getChildCount()) {
            throw new RuntimeException("Did not draw all children: " + this.mDrawChildIndex + " / " + this.getChildCount());
        }
        this.mDrawChildIndex = 0;
        if (this.mAndroidDebugDraw) {
            this.initDebugDrawResources();
            this.debugDraw(canvas);
        }
        if (this.mHotspot != null) {
            this.mHotspot.draw(canvas);
        }
    }

    private void debugDraw(Canvas canvas) {
        if (this.mDrawCommandManager != null) {
            this.mDrawCommandManager.debugDraw(canvas);
        } else {
            for (DrawCommand drawCommand : this.mDrawCommands) {
                drawCommand.debugDraw(this, canvas);
            }
        }
        this.mDrawChildIndex = 0;
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        return false;
    }

    void debugDrawNextChild(Canvas canvas) {
        View child = this.getChildAt(this.mDrawChildIndex);
        int color = child instanceof FlatViewGroup ? -12303292 : -65536;
        this.debugDrawRect(canvas, color, child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        ++this.mDrawChildIndex;
    }

    int dipsToPixels(int dips) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)((float)dips * scale + 0.5f);
    }

    private static void fillRect(Canvas canvas, Paint paint, float x1, float y1, float x2, float y2) {
        if (x1 != x2 && y1 != y2) {
            float tmp;
            if (x1 > x2) {
                tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (y1 > y2) {
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            canvas.drawRect(x1, y1, x2, y2, paint);
        }
    }

    private static int sign(float x) {
        return x >= 0.0f ? 1 : -1;
    }

    private static void drawCorner(Canvas c, Paint paint, float x1, float y1, float dx, float dy, float lw) {
        FlatViewGroup.fillRect(c, paint, x1, y1, x1 + dx, y1 + lw * (float)FlatViewGroup.sign(dy));
        FlatViewGroup.fillRect(c, paint, x1, y1, x1 + lw * (float)FlatViewGroup.sign(dx), y1 + dy);
    }

    private static void drawRectCorners(Canvas canvas, float x1, float y1, float x2, float y2, Paint paint, int lineLength, int lineWidth) {
        FlatViewGroup.drawCorner(canvas, paint, x1, y1, lineLength, lineLength, lineWidth);
        FlatViewGroup.drawCorner(canvas, paint, x1, y2, lineLength, -lineLength, lineWidth);
        FlatViewGroup.drawCorner(canvas, paint, x2, y1, -lineLength, lineLength, lineWidth);
        FlatViewGroup.drawCorner(canvas, paint, x2, y2, -lineLength, -lineLength, lineWidth);
    }

    private void initDebugDrawResources() {
        if (sDebugTextPaint == null) {
            sDebugTextPaint = new Paint();
            sDebugTextPaint.setTextAlign(Paint.Align.RIGHT);
            sDebugTextPaint.setTextSize((float)this.dipsToPixels(9));
            sDebugTextPaint.setTypeface(Typeface.MONOSPACE);
            sDebugTextPaint.setAntiAlias(true);
            sDebugTextPaint.setColor(-65536);
        }
        if (sDebugTextBackgroundPaint == null) {
            sDebugTextBackgroundPaint = new Paint();
            sDebugTextBackgroundPaint.setColor(-1);
            sDebugTextBackgroundPaint.setAlpha(200);
            sDebugTextBackgroundPaint.setStyle(Paint.Style.FILL);
        }
        if (sDebugRectPaint == null) {
            sDebugRectPaint = new Paint();
            sDebugRectPaint.setAlpha(100);
            sDebugRectPaint.setStyle(Paint.Style.STROKE);
        }
        if (sDebugCornerPaint == null) {
            sDebugCornerPaint = new Paint();
            sDebugCornerPaint.setAlpha(200);
            sDebugCornerPaint.setColor(Color.rgb((int)63, (int)127, (int)255));
            sDebugCornerPaint.setStyle(Paint.Style.FILL);
        }
        if (sDebugRect == null) {
            sDebugRect = new Rect();
        }
    }

    private void debugDrawRect(Canvas canvas, int color, float left, float top, float right, float bottom) {
        this.debugDrawNamedRect(canvas, color, "", left, top, right, bottom);
    }

    void debugDrawNamedRect(Canvas canvas, int color, String name, float left, float top, float right, float bottom) {
        sDebugRectPaint.setColor(sDebugRectPaint.getColor() & 0xFF000000 | color & 0xFFFFFF);
        sDebugRectPaint.setAlpha(100);
        canvas.drawRect(left, top, right - 1.0f, bottom - 1.0f, sDebugRectPaint);
        FlatViewGroup.drawRectCorners(canvas, left, top, right, bottom, sDebugCornerPaint, this.dipsToPixels(8), this.dipsToPixels(1));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected boolean verifyDrawable(Drawable who) {
        return true;
    }

    protected void onAttachedToWindow() {
        if (this.mIsAttached) {
            return;
        }
        this.mIsAttached = true;
        super.onAttachedToWindow();
        this.dispatchOnAttached(this.mAttachDetachListeners);
        this.updateClippingRect();
    }

    protected void onDetachedFromWindow() {
        if (!this.mIsAttached) {
            throw new RuntimeException("Double detach");
        }
        this.mIsAttached = false;
        super.onDetachedFromWindow();
        FlatViewGroup.dispatchOnDetached(this.mAttachDetachListeners);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mHotspot != null) {
            this.mHotspot.setBounds(0, 0, w, h);
            this.invalidate();
        }
        this.updateClippingRect();
    }

    public void dispatchDrawableHotspotChanged(float x, float y) {
        if (this.mHotspot != null) {
            this.mHotspot.setHotspot(x, y);
            this.invalidate();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mHotspot != null && this.mHotspot.isStateful()) {
            this.mHotspot.setState(this.getDrawableState());
        }
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mHotspot != null) {
            this.mHotspot.jumpToCurrentState();
        }
    }

    public void invalidate() {
        this.invalidate(0, 0, this.getWidth() + 1, this.getHeight() + 1);
    }

    public boolean hasOverlappingRendering() {
        return this.mNeedsOffscreenAlphaCompositing;
    }

    @Override
    public void setOnInterceptTouchEventListener(OnInterceptTouchEventListener listener) {
        this.mOnInterceptTouchEventListener = listener;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        long downTime = ev.getDownTime();
        if (downTime != this.mLastTouchDownTime) {
            this.mLastTouchDownTime = downTime;
            if (this.interceptsTouchEvent(ev.getX(), ev.getY())) {
                return true;
            }
        }
        if (this.mOnInterceptTouchEventListener != null && this.mOnInterceptTouchEventListener.onInterceptTouchEvent(this, ev)) {
            return true;
        }
        if (this.mPointerEvents == PointerEvents.NONE || this.mPointerEvents == PointerEvents.BOX_ONLY) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        NodeRegion nodeRegion;
        if (this.mPointerEvents == PointerEvents.NONE) {
            return false;
        }
        return this.mPointerEvents != PointerEvents.BOX_NONE || (nodeRegion = this.virtualNodeRegionWithinBounds(ev.getX(), ev.getY())) != null;
    }

    @Override
    public PointerEvents getPointerEvents() {
        return this.mPointerEvents;
    }

    void setPointerEvents(PointerEvents pointerEvents) {
        this.mPointerEvents = pointerEvents;
    }

    void setNeedsOffscreenAlphaCompositing(boolean needsOffscreenAlphaCompositing) {
        this.mNeedsOffscreenAlphaCompositing = needsOffscreenAlphaCompositing;
    }

    void setHotspot(Drawable hotspot) {
        if (this.mHotspot != null) {
            this.mHotspot.setCallback(null);
            this.unscheduleDrawable(this.mHotspot);
        }
        if (hotspot != null) {
            hotspot.setCallback((Drawable.Callback)this);
            if (hotspot.isStateful()) {
                hotspot.setState(this.getDrawableState());
            }
        }
        this.mHotspot = hotspot;
        this.invalidate();
    }

    void drawNextChild(Canvas canvas) {
        View child = this.getChildAt(this.mDrawChildIndex);
        if (child instanceof FlatViewGroup) {
            super.drawChild(canvas, child, this.getDrawingTime());
        } else {
            canvas.save(2);
            child.getHitRect(VIEW_BOUNDS);
            canvas.clipRect(VIEW_BOUNDS);
            super.drawChild(canvas, child, this.getDrawingTime());
            canvas.restore();
        }
        ++this.mDrawChildIndex;
    }

    void mountDrawCommands(DrawCommand[] drawCommands) {
        this.mDrawCommands = drawCommands;
        this.invalidate();
    }

    void mountClippingDrawCommands(DrawCommand[] drawCommands, SparseIntArray drawViewIndexMap, float[] maxBottom, float[] minTop, boolean willMountViews) {
        ((DrawCommandManager)Assertions.assertNotNull((Object)this.mDrawCommandManager)).mountDrawCommands(drawCommands, drawViewIndexMap, maxBottom, minTop, willMountViews);
        this.invalidate();
    }

    void onViewDropped(View view) {
        if (this.mDrawCommandManager != null) {
            this.mDrawCommandManager.onClippedViewDropped(view);
        }
    }

    NodeRegion getNodeRegionForTag(int reactTag) {
        for (NodeRegion region : this.mNodeRegions) {
            if (!region.matchesTag(reactTag)) continue;
            return region;
        }
        return NodeRegion.EMPTY;
    }

    SparseArray<View> getDetachedViews() {
        if (this.mDrawCommandManager == null) {
            return EMPTY_DETACHED_VIEWS;
        }
        return this.mDrawCommandManager.getDetachedViews();
    }

    void removeDetachedView(View view) {
        this.removeDetachedView(view, false);
    }

    public void removeAllViewsInLayout() {
        this.mDrawCommands = DrawCommand.EMPTY_ARRAY;
        super.removeAllViewsInLayout();
    }

    void mountAttachDetachListeners(AttachDetachListener[] listeners) {
        if (this.mIsAttached) {
            this.dispatchOnAttached(listeners);
            FlatViewGroup.dispatchOnDetached(this.mAttachDetachListeners);
        }
        this.mAttachDetachListeners = listeners;
    }

    void mountNodeRegions(NodeRegion[] nodeRegions) {
        this.mNodeRegions = nodeRegions;
    }

    void mountClippingNodeRegions(NodeRegion[] nodeRegions, float[] maxBottom, float[] minTop) {
        this.mNodeRegions = nodeRegions;
        ((DrawCommandManager)Assertions.assertNotNull((Object)this.mDrawCommandManager)).mountNodeRegions(nodeRegions, maxBottom, minTop);
    }

    void mountViews(ViewResolver viewResolver, int[] viewsToAdd, int[] viewsToDetach) {
        if (this.mDrawCommandManager != null) {
            this.mDrawCommandManager.mountViews(viewResolver, viewsToAdd, viewsToDetach);
        } else {
            View view;
            for (int viewToAdd : viewsToAdd) {
                if (viewToAdd > 0) {
                    view = viewResolver.getView(viewToAdd);
                    FlatViewGroup.ensureViewHasNoParent(view);
                    this.addViewInLayout(view);
                    continue;
                }
                view = viewResolver.getView(-viewToAdd);
                FlatViewGroup.ensureViewHasNoParent(view);
                this.attachViewToParent(view);
            }
            for (int viewToDetach : viewsToDetach) {
                view = viewResolver.getView(viewToDetach);
                if (view.getParent() != null) {
                    throw new RuntimeException("Trying to remove view not owned by FlatViewGroup");
                }
                this.removeDetachedView(view, false);
            }
        }
        this.invalidate();
    }

    void addViewInLayout(View view) {
        this.addViewInLayout(view, -1, this.ensureLayoutParams(view.getLayoutParams()), true);
    }

    void addViewInLayout(View view, int index) {
        this.addViewInLayout(view, index, this.ensureLayoutParams(view.getLayoutParams()), true);
    }

    void attachViewToParent(View view) {
        this.attachViewToParent(view, -1, this.ensureLayoutParams(view.getLayoutParams()));
    }

    void attachViewToParent(View view, int index) {
        this.attachViewToParent(view, index, this.ensureLayoutParams(view.getLayoutParams()));
    }

    private void processLayoutRequest() {
        this.mIsLayoutRequested = false;
        int childCount = this.getChildCount();
        for (int i = 0; i != childCount; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutRequested()) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)child.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getHeight(), (int)0x40000000));
            child.layout(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        }
    }

    static void processLayoutRequests() {
        int numLayoutRequests = LAYOUT_REQUESTS.size();
        for (int i = 0; i != numLayoutRequests; ++i) {
            FlatViewGroup flatViewGroup = LAYOUT_REQUESTS.get(i);
            flatViewGroup.processLayoutRequest();
        }
        LAYOUT_REQUESTS.clear();
    }

    @Override
    public Rect measureWithCommands() {
        int childCount = this.getChildCount();
        if (childCount == 0 && this.mDrawCommands.length == 0) {
            return new Rect(0, 0, 0, 0);
        }
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            left = Math.min(left, child.getLeft());
            top = Math.min(top, child.getTop());
            right = Math.max(right, child.getRight());
            bottom = Math.max(bottom, child.getBottom());
        }
        for (DrawCommand mDrawCommand : this.mDrawCommands) {
            if (!(mDrawCommand instanceof AbstractDrawCommand)) continue;
            AbstractDrawCommand drawCommand = (AbstractDrawCommand)mDrawCommand;
            left = Math.min(left, Math.round(drawCommand.getLeft()));
            top = Math.min(top, Math.round(drawCommand.getTop()));
            right = Math.max(right, Math.round(drawCommand.getRight()));
            bottom = Math.max(bottom, Math.round(drawCommand.getBottom()));
        }
        return new Rect(left, top, right, bottom);
    }

    @Nullable
    private NodeRegion virtualNodeRegionWithinBounds(float touchX, float touchY) {
        if (this.mDrawCommandManager != null) {
            return this.mDrawCommandManager.virtualNodeRegionWithinBounds(touchX, touchY);
        }
        for (int i = this.mNodeRegions.length - 1; i >= 0; --i) {
            NodeRegion nodeRegion = this.mNodeRegions[i];
            if (!nodeRegion.mIsVirtual || !nodeRegion.withinBounds(touchX, touchY)) continue;
            return nodeRegion;
        }
        return null;
    }

    @Nullable
    private NodeRegion anyNodeRegionWithinBounds(float touchX, float touchY) {
        if (this.mDrawCommandManager != null) {
            return this.mDrawCommandManager.anyNodeRegionWithinBounds(touchX, touchY);
        }
        for (int i = this.mNodeRegions.length - 1; i >= 0; --i) {
            NodeRegion nodeRegion = this.mNodeRegions[i];
            if (!nodeRegion.withinBounds(touchX, touchY)) continue;
            return nodeRegion;
        }
        return null;
    }

    private static void ensureViewHasNoParent(View view) {
        ViewParent oldParent = view.getParent();
        if (oldParent != null) {
            throw new RuntimeException("Cannot add view " + view + " to FlatViewGroup while it has a parent " + oldParent);
        }
    }

    private void dispatchOnAttached(AttachDetachListener[] listeners) {
        int numListeners = listeners.length;
        if (numListeners == 0) {
            return;
        }
        InvalidateCallback callback = this.getInvalidateCallback();
        for (AttachDetachListener listener : listeners) {
            listener.onAttached(callback);
        }
    }

    private InvalidateCallback getInvalidateCallback() {
        if (this.mInvalidateCallback == null) {
            this.mInvalidateCallback = new InvalidateCallback(this);
        }
        return this.mInvalidateCallback;
    }

    private static void dispatchOnDetached(AttachDetachListener[] listeners) {
        for (AttachDetachListener listener : listeners) {
            listener.onDetached();
        }
    }

    private ViewGroup.LayoutParams ensureLayoutParams(ViewGroup.LayoutParams lp) {
        if (this.checkLayoutParams(lp)) {
            return lp;
        }
        return this.generateDefaultLayoutParams();
    }

    @Override
    public void updateClippingRect() {
        if (this.mDrawCommandManager == null) {
            return;
        }
        if (this.mDrawCommandManager.updateClippingRect()) {
            this.invalidate();
        }
    }

    @Override
    public void getClippingRect(Rect outClippingRect) {
        if (this.mDrawCommandManager == null) {
            throw new RuntimeException("Trying to get the clipping rect for a non-clipping FlatViewGroup");
        }
        this.mDrawCommandManager.getClippingRect(outClippingRect);
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        boolean currentlyClipping = this.getRemoveClippedSubviews();
        if (removeClippedSubviews == currentlyClipping) {
            return;
        }
        if (currentlyClipping) {
            throw new RuntimeException("Trying to transition FlatViewGroup from clipping to non-clipping state");
        }
        this.mDrawCommandManager = DrawCommandManager.getVerticalClippingInstance(this, this.mDrawCommands);
        this.mDrawCommands = DrawCommand.EMPTY_ARRAY;
    }

    @Override
    public boolean getRemoveClippedSubviews() {
        return this.mDrawCommandManager != null;
    }

    @Override
    @Nullable
    public Rect getHitSlopRect() {
        return this.mHitSlopRect;
    }

    void setHitSlopRect(@Nullable Rect rect) {
        this.mHitSlopRect = rect;
    }

    static {
        LAYOUT_REQUESTS = new ArrayList();
        VIEW_BOUNDS = new Rect();
        EMPTY_DETACHED_VIEWS = new SparseArray(0);
    }

    static final class InvalidateCallback
    extends WeakReference<FlatViewGroup> {
        private InvalidateCallback(FlatViewGroup view) {
            super(view);
        }

        public void invalidate() {
            FlatViewGroup view = (FlatViewGroup)this.get();
            if (view != null) {
                view.invalidate();
            }
        }

        public void dispatchImageLoadEvent(int reactTag, int imageLoadEvent) {
            FlatViewGroup view = (FlatViewGroup)this.get();
            if (view == null) {
                return;
            }
            ReactContext reactContext = (ReactContext)view.getContext();
            UIManagerModule uiManagerModule = reactContext.getNativeModule(UIManagerModule.class);
            uiManagerModule.getEventDispatcher().dispatchEvent(new ImageLoadEvent(reactTag, imageLoadEvent));
        }
    }
}

